/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.queryresultscache;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.annotation.Priority;
import javax.inject.Named;
import org.apache.isis.applib.annotation.InteractionScope;
import org.apache.isis.applib.services.queryresultscache.MethodReferences;
import org.apache.isis.applib.services.queryresultscache.QueryResultsCacheControl;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.collections._Maps;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
@Named(value="isis.applib.QueryResultsCache")
@Priority(value=0x1FFFFFFF)
@InteractionScope
@Qualifier(value="Default")
public class QueryResultsCache
implements DisposableBean {
    private static final Logger log = LogManager.getLogger(QueryResultsCache.class);
    static final String LOGICAL_TYPE_NAME = "isis.applib.QueryResultsCache";
    private final Map<Key, Value<?>> cache = _Maps.newHashMap();
    @Autowired(required=false)
    protected List<QueryResultsCacheControl> cacheControl;

    public <T> T execute(Callable<T> callable, Class<?> callingClass, String methodName, Object ... keys) {
        if (this.isIgnoreCache()) {
            try {
                return callable.call();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        Key cacheKey = new Key(callingClass, methodName, keys);
        return this.executeWithCaching(callable, cacheKey);
    }

    public <R> R execute(MethodReferences.Call0<? extends R> action, Class<?> callingClass, String methodName) {
        if (this.isIgnoreCache()) {
            return action.call();
        }
        Key cacheKey = new Key(callingClass, methodName, new Object[0]);
        return (R)this.executeWithCaching(action::call, cacheKey);
    }

    public <R, A0> R execute(MethodReferences.Call1<? extends R, A0> action, Class<?> callingClass, String methodName, A0 arg0) {
        if (this.isIgnoreCache()) {
            return action.call(arg0);
        }
        Key cacheKey = new Key(callingClass, methodName, arg0);
        return (R)this.executeWithCaching(() -> action.call(arg0), cacheKey);
    }

    public <R, A0, A1> R execute(MethodReferences.Call2<? extends R, A0, A1> action, Class<?> callingClass, String methodName, A0 arg0, A1 arg1) {
        if (this.isIgnoreCache()) {
            return action.call(arg0, arg1);
        }
        Key cacheKey = new Key(callingClass, methodName, arg0, arg1);
        return (R)this.executeWithCaching(() -> action.call(arg0, arg1), cacheKey);
    }

    public <R, A0, A1, A2> R execute(MethodReferences.Call3<? extends R, A0, A1, A2> action, Class<?> callingClass, String methodName, A0 arg0, A1 arg1, A2 arg2) {
        if (this.isIgnoreCache()) {
            return action.call(arg0, arg1, arg2);
        }
        Key cacheKey = new Key(callingClass, methodName, arg0, arg1, arg2);
        return (R)this.executeWithCaching(() -> action.call(arg0, arg1, arg2), cacheKey);
    }

    public <R, A0, A1, A2, A3> R execute(MethodReferences.Call4<? extends R, A0, A1, A2, A3> action, Class<?> callingClass, String methodName, A0 arg0, A1 arg1, A2 arg2, A3 arg3) {
        if (this.isIgnoreCache()) {
            return action.call(arg0, arg1, arg2, arg3);
        }
        Key cacheKey = new Key(callingClass, methodName, arg0, arg1, arg2, arg3);
        return (R)this.executeWithCaching(() -> action.call(arg0, arg1, arg2, arg3), cacheKey);
    }

    public <R, A0, A1, A2, A3, A4> R execute(MethodReferences.Call5<? extends R, A0, A1, A2, A3, A4> action, Class<?> callingClass, String methodName, A0 arg0, A1 arg1, A2 arg2, A3 arg3, A4 arg4) {
        if (this.isIgnoreCache()) {
            return action.call(arg0, arg1, arg2, arg3, arg4);
        }
        Key cacheKey = new Key(callingClass, methodName, arg0, arg1, arg2, arg3, arg4);
        return (R)this.executeWithCaching(() -> action.call(arg0, arg1, arg2, arg3, arg4), cacheKey);
    }

    private <T> T executeWithCaching(Callable<T> callable, Key cacheKey) {
        try {
            Value<?> cacheValue = this.cache.get(cacheKey);
            QueryResultsCache.logHitOrMiss(cacheKey, cacheValue);
            if (cacheValue != null) {
                return (T)_Casts.uncheckedCast(cacheValue.getResult());
            }
            T result = callable.call();
            this.put(cacheKey, result);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private <T> void put(Key cacheKey, T result) {
        log.debug("PUT: {}", (Object)cacheKey);
        this.cache.put(cacheKey, new Value<T>(result));
    }

    private static void logHitOrMiss(Key cacheKey, Value<?> cacheValue) {
        if (!log.isDebugEnabled()) {
            return;
        }
        log.debug("{}: {}", (Object)(cacheValue != null ? "HIT" : "MISS"), (Object)cacheKey.toString());
    }

    public void onTransactionEnded() {
        this.cache.clear();
    }

    public void destroy() throws Exception {
        this.cache.clear();
    }

    private boolean isIgnoreCache() {
        return _NullSafe.stream(this.cacheControl).anyMatch(c -> c.isIgnoreCache());
    }

    class Value<T> {
        private final T result;

        public Value(T result) {
            this.result = result;
        }

        public T getResult() {
            return this.result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Value)) {
                return false;
            }
            Value other = (Value)o;
            if (!other.canEqual(this)) {
                return false;
            }
            T this$result = this.getResult();
            T other$result = other.getResult();
            return !(this$result == null ? other$result != null : !this$result.equals(other$result));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Value;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            T $result = this.getResult();
            result = result * 59 + ($result == null ? 43 : $result.hashCode());
            return result;
        }

        public String toString() {
            return "QueryResultsCache.Value(result=" + this.getResult() + ")";
        }
    }

    public static class Key {
        private final Class<?> callingClass;
        private final String methodName;
        private final Object[] keys;

        public Key(Class<?> callingClass, String methodName, Object ... keys) {
            this.callingClass = callingClass;
            this.methodName = methodName;
            this.keys = keys;
        }

        public String toString() {
            return this.callingClass.getName() + "#" + this.methodName + Arrays.toString(this.keys);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key other = (Key)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Class<?> this$callingClass = this.getCallingClass();
            Class<?> other$callingClass = other.getCallingClass();
            if (this$callingClass == null ? other$callingClass != null : !this$callingClass.equals(other$callingClass)) {
                return false;
            }
            String this$methodName = this.getMethodName();
            String other$methodName = other.getMethodName();
            if (this$methodName == null ? other$methodName != null : !this$methodName.equals(other$methodName)) {
                return false;
            }
            return Arrays.deepEquals(this.getKeys(), other.getKeys());
        }

        protected boolean canEqual(Object other) {
            return other instanceof Key;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<?> $callingClass = this.getCallingClass();
            result = result * 59 + ($callingClass == null ? 43 : $callingClass.hashCode());
            String $methodName = this.getMethodName();
            result = result * 59 + ($methodName == null ? 43 : $methodName.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getKeys());
            return result;
        }

        public Class<?> getCallingClass() {
            return this.callingClass;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public Object[] getKeys() {
            return this.keys;
        }
    }
}

