/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.publishing.spi;

import java.sql.Timestamp;
import java.util.UUID;
import org.apache.isis.applib.services.bookmark.Bookmark;

public final class EntityPropertyChange {
    private final UUID interactionId;
    private final int sequence;
    private final Bookmark target;
    private final String logicalMemberIdentifier;
    private final String propertyId;
    private final String preValue;
    private final String postValue;
    private final String username;
    private final Timestamp timestamp;

    public String toString() {
        return String.format("%s,%d: %s by %s, %s: %s -> %s", this.getInteractionId(), this.getSequence(), this.getTarget().toString(), this.getUsername(), this.getPropertyId(), this.getPreValue(), this.getPostValue());
    }

    private EntityPropertyChange(UUID interactionId, int sequence, Bookmark target, String logicalMemberIdentifier, String propertyId, String preValue, String postValue, String username, Timestamp timestamp) {
        this.interactionId = interactionId;
        this.sequence = sequence;
        this.target = target;
        this.logicalMemberIdentifier = logicalMemberIdentifier;
        this.propertyId = propertyId;
        this.preValue = preValue;
        this.postValue = postValue;
        this.username = username;
        this.timestamp = timestamp;
    }

    public static EntityPropertyChange of(UUID interactionId, int sequence, Bookmark target, String logicalMemberIdentifier, String propertyId, String preValue, String postValue, String username, Timestamp timestamp) {
        return new EntityPropertyChange(interactionId, sequence, target, logicalMemberIdentifier, propertyId, preValue, postValue, username, timestamp);
    }

    public UUID getInteractionId() {
        return this.interactionId;
    }

    public int getSequence() {
        return this.sequence;
    }

    public Bookmark getTarget() {
        return this.target;
    }

    public String getLogicalMemberIdentifier() {
        return this.logicalMemberIdentifier;
    }

    public String getPropertyId() {
        return this.propertyId;
    }

    public String getPreValue() {
        return this.preValue;
    }

    public String getPostValue() {
        return this.postValue;
    }

    public String getUsername() {
        return this.username;
    }

    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntityPropertyChange)) {
            return false;
        }
        EntityPropertyChange other = (EntityPropertyChange)o;
        if (this.getSequence() != other.getSequence()) {
            return false;
        }
        UUID this$interactionId = this.getInteractionId();
        UUID other$interactionId = other.getInteractionId();
        if (this$interactionId == null ? other$interactionId != null : !((Object)this$interactionId).equals(other$interactionId)) {
            return false;
        }
        Bookmark this$target = this.getTarget();
        Bookmark other$target = other.getTarget();
        if (this$target == null ? other$target != null : !((Object)this$target).equals(other$target)) {
            return false;
        }
        String this$logicalMemberIdentifier = this.getLogicalMemberIdentifier();
        String other$logicalMemberIdentifier = other.getLogicalMemberIdentifier();
        if (this$logicalMemberIdentifier == null ? other$logicalMemberIdentifier != null : !this$logicalMemberIdentifier.equals(other$logicalMemberIdentifier)) {
            return false;
        }
        String this$propertyId = this.getPropertyId();
        String other$propertyId = other.getPropertyId();
        if (this$propertyId == null ? other$propertyId != null : !this$propertyId.equals(other$propertyId)) {
            return false;
        }
        String this$preValue = this.getPreValue();
        String other$preValue = other.getPreValue();
        if (this$preValue == null ? other$preValue != null : !this$preValue.equals(other$preValue)) {
            return false;
        }
        String this$postValue = this.getPostValue();
        String other$postValue = other.getPostValue();
        if (this$postValue == null ? other$postValue != null : !this$postValue.equals(other$postValue)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        Timestamp this$timestamp = this.getTimestamp();
        Timestamp other$timestamp = other.getTimestamp();
        return !(this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSequence();
        UUID $interactionId = this.getInteractionId();
        result = result * 59 + ($interactionId == null ? 43 : ((Object)$interactionId).hashCode());
        Bookmark $target = this.getTarget();
        result = result * 59 + ($target == null ? 43 : ((Object)$target).hashCode());
        String $logicalMemberIdentifier = this.getLogicalMemberIdentifier();
        result = result * 59 + ($logicalMemberIdentifier == null ? 43 : $logicalMemberIdentifier.hashCode());
        String $propertyId = this.getPropertyId();
        result = result * 59 + ($propertyId == null ? 43 : $propertyId.hashCode());
        String $preValue = this.getPreValue();
        result = result * 59 + ($preValue == null ? 43 : $preValue.hashCode());
        String $postValue = this.getPostValue();
        result = result * 59 + ($postValue == null ? 43 : $postValue.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        Timestamp $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        return result;
    }
}

