/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.publishing.log;

import javax.annotation.Priority;
import javax.inject.Named;
import org.apache.isis.applib.services.iactn.Execution;
import org.apache.isis.applib.services.publishing.spi.ExecutionSubscriber;
import org.apache.isis.applib.util.schema.InteractionDtoUtils;
import org.apache.isis.schema.ixn.v2.InteractionDto;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@Named(value="isis.applib.ExecutionLogger")
@Priority(value=0x5FFFFFFF)
@Qualifier(value="Logging")
public class ExecutionLogger
implements ExecutionSubscriber {
    private static final Logger log = LogManager.getLogger(ExecutionLogger.class);
    static final String LOGICAL_TYPE_NAME = "isis.applib.ExecutionLogger";

    public boolean isEnabled() {
        return log.isDebugEnabled();
    }

    @Override
    public void onExecution(Execution<?, ?> execution) {
        InteractionDto interactionDto = InteractionDtoUtils.newInteractionDto(execution, InteractionDtoUtils.Strategy.DEEP);
        log.debug(InteractionDtoUtils.toXml(interactionDto));
    }
}

