/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.publishing.log;

import javax.annotation.Priority;
import javax.inject.Named;
import org.apache.isis.applib.services.publishing.spi.EntityChanges;
import org.apache.isis.applib.services.publishing.spi.EntityChangesSubscriber;
import org.apache.isis.applib.util.schema.ChangesDtoUtils;
import org.apache.isis.schema.chg.v2.ChangesDto;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@Named(value="isis.applib.EntityChangesLogger")
@Priority(value=0x5FFFFFFF)
@Qualifier(value="Logging")
public class EntityChangesLogger
implements EntityChangesSubscriber {
    private static final Logger log = LogManager.getLogger(EntityChangesLogger.class);
    static final String LOGICAL_TYPE_NAME = "isis.applib.EntityChangesLogger";

    public boolean isEnabled() {
        return log.isDebugEnabled();
    }

    @Override
    public void onChanging(EntityChanges changingEntities) {
        ChangesDto changesDto = changingEntities.getDto();
        log.debug(ChangesDtoUtils.toXml(changesDto));
    }
}

