/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.publishing.log;

import javax.annotation.Priority;
import javax.inject.Named;
import org.apache.isis.applib.services.command.Command;
import org.apache.isis.applib.services.publishing.spi.CommandSubscriber;
import org.apache.isis.applib.util.schema.CommandDtoUtils;
import org.apache.isis.schema.cmd.v2.CommandDto;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@Named(value="isis.applib.CommandLogger")
@Priority(value=0x5FFFFFFF)
@Qualifier(value="Logging")
public class CommandLogger
implements CommandSubscriber {
    private static final Logger log = LogManager.getLogger(CommandLogger.class);
    static final String LOGICAL_TYPE_NAME = "isis.applib.CommandLogger";

    public boolean isEnabled() {
        return log.isDebugEnabled();
    }

    @Override
    public void onCompleted(Command command) {
        CommandDto commandDto = command.getCommandDto();
        String xml = CommandDtoUtils.toXml(commandDto);
        log.debug("completed: {}, systemStateChanged {} \n{}", (Object)command.getLogicalMemberIdentifier(), (Object)command.isSystemStateChanged(), (Object)xml);
    }
}

