/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.placeholder;

import lombok.NonNull;

public interface PlaceholderRenderService {
    public String asText(@NonNull PlaceholderLiteral var1);

    public String asHtml(@NonNull PlaceholderLiteral var1);

    public static PlaceholderRenderService fallback() {
        return new PlaceholderRenderService(){

            @Override
            public String asText(@NonNull PlaceholderLiteral placeholderLiteral) {
                if (placeholderLiteral == null) {
                    throw new NullPointerException("placeholderLiteral is marked non-null but is null");
                }
                return "(" + placeholderLiteral.getLiteral() + ")";
            }

            @Override
            public String asHtml(@NonNull PlaceholderLiteral placeholderLiteral) {
                if (placeholderLiteral == null) {
                    throw new NullPointerException("placeholderLiteral is marked non-null but is null");
                }
                return this.asText(placeholderLiteral);
            }
        };
    }

    public static enum PlaceholderLiteral {
        NULL_REPRESENTATION("none"),
        SUPPRESSED("suppressed");

        private final String literal;

        public String getLiteral() {
            return this.literal;
        }

        private PlaceholderLiteral(String literal) {
            this.literal = literal;
        }
    }
}

