/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.metamodel;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.isis.commons.collections.Can;
import org.apache.isis.commons.internal.assertions._Assert;
import org.apache.isis.commons.internal.collections._Sets;
import org.apache.isis.commons.internal.collections._Streams;
import org.apache.isis.schema.metamodel.v2.DomainClassDto;
import org.apache.isis.schema.metamodel.v2.Facet;
import org.apache.isis.schema.metamodel.v2.FacetAttr;
import org.apache.isis.schema.metamodel.v2.FacetHolder;
import org.apache.isis.schema.metamodel.v2.Member;
import org.apache.isis.schema.metamodel.v2.MetamodelDto;

final class _DiffExport {
    private static final String LEFT_SYMBOL = "L";
    private static final String RIGHT_SYMBOL = "R";
    private static final String DIFF_SYMBOL = "D";

    static StringBuilder toDiff(MetamodelDto leftMetamodelDto, MetamodelDto rightMetamodelDto) {
        TreeMap leftTypesById = new TreeMap();
        TreeMap rightTypesById = new TreeMap();
        TreeMap facetsById = new TreeMap();
        Consumer<Facet> facetCollector = facet -> facetsById.put(facet.getId(), facet);
        _DiffExport.visitAllFacets(leftMetamodelDto, facetCollector);
        _DiffExport.visitAllFacets(rightMetamodelDto, facetCollector);
        StringBuilder sb = new StringBuilder();
        Set leftTypes = _DiffExport.streamTypes(leftMetamodelDto).peek(type -> leftTypesById.put(type.getId(), type)).map(DomainClassDto::getId).collect(Collectors.toSet());
        Set rightTypes = _DiffExport.streamTypes(rightMetamodelDto).peek(type -> rightTypesById.put(type.getId(), type)).map(DomainClassDto::getId).collect(Collectors.toSet());
        Set leftNotInRight = _Sets.minus(leftTypes, rightTypes);
        Set rightNotInLeft = _Sets.minus(rightTypes, leftTypes);
        leftNotInRight.stream().forEach(typeId -> sb.append(LEFT_SYMBOL).append(" ").append((String)typeId).append("\n"));
        rightNotInLeft.stream().forEach(typeId -> sb.append(RIGHT_SYMBOL).append(" ").append((String)typeId).append("\n"));
        Set inLeftAndRight = _Sets.intersect(leftTypes, rightTypes);
        Can leftTypeIntersection = (Can)inLeftAndRight.stream().sorted().map(leftTypesById::get).collect(Can.toCan());
        Can rightTypeIntersection = (Can)inLeftAndRight.stream().sorted().map(rightTypesById::get).collect(Can.toCan());
        TreeMap leftMembersByKey = new TreeMap();
        TreeMap rightMembersByKey = new TreeMap();
        leftTypeIntersection.stream().forEach(type -> _DiffExport.streamMembers(type).forEach(m -> {
            String key = _DiffExport.memberKey(type, m);
            leftMembersByKey.put(key, m);
            m.setId(key);
        }));
        rightTypeIntersection.stream().forEach(type -> _DiffExport.streamMembers(type).forEach(m -> {
            String key = _DiffExport.memberKey(type, m);
            rightMembersByKey.put(key, m);
            m.setId(key);
        }));
        Set leftNotInRightM = _Sets.minus(leftMembersByKey.keySet(), rightMembersByKey.keySet());
        Set rightNotInLeftM = _Sets.minus(rightMembersByKey.keySet(), leftMembersByKey.keySet());
        leftNotInRightM.stream().forEach(memberKey -> sb.append(LEFT_SYMBOL).append(" ").append((String)memberKey).append("\n"));
        rightNotInLeftM.stream().forEach(memberKey -> sb.append(RIGHT_SYMBOL).append(" ").append((String)memberKey).append("\n"));
        Set inLeftAndRightM = _Sets.intersect(leftMembersByKey.keySet(), rightMembersByKey.keySet());
        Can leftMemberIntersection = (Can)inLeftAndRightM.stream().sorted().map(leftMembersByKey::get).collect(Can.toCan());
        Can rightMemberIntersection = (Can)inLeftAndRightM.stream().sorted().map(rightMembersByKey::get).collect(Can.toCan());
        facetsById.values().forEach(facet -> {
            DiffModel diffModel = new DiffModel(f -> f.getId().equals(facet.getId()), (Can<DomainClassDto>)leftTypeIntersection, (Can<DomainClassDto>)rightTypeIntersection, (Can<Member>)leftMemberIntersection, (Can<Member>)rightMemberIntersection);
            _DiffExport.diff(diffModel, leftMetamodelDto, rightMetamodelDto);
            if (diffModel.isEmpty()) {
                return;
            }
            sb.append('[').append(facet.getId()).append(']').append("\n\n");
            sb.append(diffModel.sb.toString());
            sb.append("\n");
        });
        return sb;
    }

    private static void diff(DiffModel diffModel, MetamodelDto leftMetamodelDto, MetamodelDto rightMetamodelDto) {
        diffModel.leftIntersection.zip(diffModel.rightIntersection, (leftType, rightType) -> _DiffExport.diffFacets(diffModel, leftType.getId(), leftType.getFacets(), rightType.getFacets()));
        diffModel.leftMemberIntersection.zip(diffModel.rightMemberIntersection, (leftMember, rightMember) -> _DiffExport.diffFacets(diffModel, leftMember.getId(), leftMember.getFacets(), rightMember.getFacets()));
    }

    private static void diffFacets(DiffModel diffModel, String typeOrMemberId, FacetHolder.Facets leftFacets, FacetHolder.Facets rightFacets) {
        Optional<Facet> leftFacet = _DiffExport.findFirstFacet(leftFacets, diffModel.facetFilter);
        Optional<Facet> rightFacet = _DiffExport.findFirstFacet(rightFacets, diffModel.facetFilter);
        if (leftFacet.isPresent()) {
            if (!rightFacet.isPresent()) {
                _DiffExport.reportFacetNotInOther(diffModel, LEFT_SYMBOL, typeOrMemberId, leftFacet.get());
            } else {
                _DiffExport.diffAttrs(diffModel, typeOrMemberId, leftFacet.get(), rightFacet.get());
            }
        } else if (rightFacet.isPresent()) {
            _DiffExport.reportFacetNotInOther(diffModel, RIGHT_SYMBOL, typeOrMemberId, rightFacet.get());
        }
    }

    private static void reportFacetNotInOther(DiffModel diffModel, String symbol, String typeOrMemberId, Facet facet) {
        StringBuilder sb = diffModel.sb;
        Can attrNameValueLiterals = (Can)_DiffExport.streamFacetAttr(facet).map(attr -> attr.getName() + " " + attr.getValue()).collect(Can.toCan());
        Can attrNameValueOrEmptyLiterals = attrNameValueLiterals.isEmpty() ? Can.of((Object[])new String[]{"<no-attributes>"}) : attrNameValueLiterals;
        attrNameValueOrEmptyLiterals.forEach(attrNameValueLiteral -> sb.append(symbol).append(" ").append(typeOrMemberId).append(" ").append((String)attrNameValueLiteral).append("\n"));
        ++diffModel.diffCout;
    }

    private static void diffAttrs(DiffModel diffModel, String typeOrMemberId, Facet leftFacet, Facet rightFacet) {
        StringBuilder sb = diffModel.sb;
        TreeMap leftAttrByName = new TreeMap();
        TreeMap rightAttrByName = new TreeMap();
        Set leftAttrNames = _DiffExport.streamFacetAttr(leftFacet).peek(attr -> leftAttrByName.put(attr.getName(), attr)).map(FacetAttr::getName).collect(Collectors.toSet());
        Set rightAttrNames = _DiffExport.streamFacetAttr(rightFacet).peek(attr -> rightAttrByName.put(attr.getName(), attr)).map(FacetAttr::getName).collect(Collectors.toSet());
        Set leftNotInRight = _Sets.minus(leftAttrNames, rightAttrNames);
        Set rightNotInLeft = _Sets.minus(rightAttrNames, leftAttrNames);
        leftNotInRight.stream().peek(__ -> ++diffModel.diffCout).forEach(attrName -> sb.append(LEFT_SYMBOL).append(" ").append(typeOrMemberId).append(" ").append((String)attrName).append(" ").append(((FacetAttr)leftAttrByName.get(attrName)).getValue()).append("\n"));
        rightNotInLeft.stream().peek(__ -> ++diffModel.diffCout).forEach(attrName -> sb.append(RIGHT_SYMBOL).append(" ").append(typeOrMemberId).append(" ").append((String)attrName).append(" ").append(((FacetAttr)rightAttrByName.get(attrName)).getValue()).append("\n"));
        Set inLeftAndRight = _Sets.intersect(leftAttrNames, rightAttrNames);
        Can leftAttrIntersection = (Can)inLeftAndRight.stream().sorted().map(leftAttrByName::get).collect(Can.toCan());
        Can rightAttrIntersection = (Can)inLeftAndRight.stream().sorted().map(rightAttrByName::get).collect(Can.toCan());
        leftAttrIntersection.zip((Iterable)rightAttrIntersection, (leftAttr, rightAttr) -> {
            _Assert.assertEquals((Object)leftAttr.getName(), (Object)rightAttr.getName());
            if (Objects.equals(leftAttr.getValue(), rightAttr.getValue())) {
                return;
            }
            sb.append(DIFF_SYMBOL).append(" ").append(typeOrMemberId).append(" ").append(leftAttr.getName()).append(" ").append(leftAttr.getValue()).append(" <-> ").append(rightAttr.getValue()).append("\n");
            ++diffModel.diffCout;
        });
    }

    private static Stream<DomainClassDto> streamTypes(MetamodelDto mmDto) {
        return mmDto.getDomainClassDto().stream().sorted((a, b) -> a.getId().compareTo(b.getId()));
    }

    private static Stream<Member> streamMembers(DomainClassDto typeDto) {
        return _Streams.concat(Optional.ofNullable(typeDto.getProperties()).map(props -> props.getProp()).map(Collection::stream).orElse(Stream.empty()).sorted((a, b) -> a.getId().compareTo(b.getId())), Optional.ofNullable(typeDto.getCollections()).map(colls -> colls.getColl()).map(Collection::stream).orElse(Stream.empty()).sorted((a, b) -> a.getId().compareTo(b.getId())), Optional.ofNullable(typeDto.getActions()).map(acts -> acts.getAct()).map(Collection::stream).orElse(Stream.empty()).sorted((a, b) -> a.getId().compareTo(b.getId())));
    }

    private static Optional<Facet> findFirstFacet(FacetHolder.Facets x, Predicate<Facet> filter) {
        return Optional.ofNullable(x).map(FacetHolder.Facets::getFacet).map(Collection::stream).orElse(Stream.empty()).filter(filter).findFirst();
    }

    private static Stream<Facet> streamFacets(DomainClassDto x) {
        return Optional.ofNullable(x.getFacets()).map(FacetHolder.Facets::getFacet).map(Collection::stream).orElse(Stream.empty());
    }

    private static Stream<Facet> streamFacets(Member x) {
        return Optional.ofNullable(x.getFacets()).map(FacetHolder.Facets::getFacet).map(Collection::stream).orElse(Stream.empty());
    }

    private static Stream<FacetAttr> streamFacetAttr(Facet x) {
        return Optional.ofNullable(x.getAttr()).map(Collection::stream).orElse(Stream.empty()).sorted((a, b) -> a.getName().compareTo(b.getName()));
    }

    private static String memberKey(DomainClassDto type, Member member) {
        return type.getId() + "#" + member.getId();
    }

    private static void visitAllFacets(MetamodelDto mmDto, Consumer<? super Facet> onFacet) {
        _DiffExport.streamTypes(mmDto).peek(x -> _DiffExport.streamFacets(x).forEach(onFacet)).flatMap(_DiffExport::streamMembers).flatMap(_DiffExport::streamFacets).forEach(onFacet);
    }

    private _DiffExport() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static class DiffModel {
        final StringBuilder sb = new StringBuilder();
        final Predicate<Facet> facetFilter;
        final Can<DomainClassDto> leftIntersection;
        final Can<DomainClassDto> rightIntersection;
        final Can<Member> leftMemberIntersection;
        final Can<Member> rightMemberIntersection;
        long diffCout;

        boolean isEmpty() {
            return this.diffCout == 0L;
        }

        public DiffModel(Predicate<Facet> facetFilter, Can<DomainClassDto> leftIntersection, Can<DomainClassDto> rightIntersection, Can<Member> leftMemberIntersection, Can<Member> rightMemberIntersection) {
            this.facetFilter = facetFilter;
            this.leftIntersection = leftIntersection;
            this.rightIntersection = rightIntersection;
            this.leftMemberIntersection = leftMemberIntersection;
            this.rightMemberIntersection = rightMemberIntersection;
        }
    }
}

