/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.metamodel;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.isis.applib.services.metamodel.DomainMember;
import org.apache.isis.applib.services.metamodel.DomainModel;
import org.apache.isis.commons.internal.collections._Lists;

final class _CsvExport {
    static StringBuilder toCsv(DomainModel domainModel) {
        return _CsvExport.asBuf(_CsvExport.asList(domainModel));
    }

    private static StringBuilder asBuf(List<String> list) {
        StringBuilder buf = new StringBuilder();
        for (String row : list) {
            buf.append(row).append("\n");
        }
        return buf;
    }

    private static List<String> asList(DomainModel model) {
        ArrayList list = _Lists.newArrayList();
        list.add(_CsvExport.header());
        for (DomainMember row : model.getDomainMembers()) {
            list.add(_CsvExport.asTextCsv(row));
        }
        return list;
    }

    private static String header() {
        return "classType,logicalTypeName,className,packageName,memberType,memberName,numParams,mixedIn?,mixin,hidden,disabled,choices,autoComplete,default,validate";
    }

    private static String asTextCsv(DomainMember row) {
        return Stream.of(row.getClassType(), row.getLogicalTypeName(), row.getClassName(), row.getPackageName(), row.getType(), row.getMemberName(), row.getNumParams(), row.isMixedIn() ? "Y" : "", row.getMixin(), row.getHidden(), row.getDisabled(), row.getChoices(), row.getAutoComplete(), row.getDefault(), row.getValidate()).collect(Collectors.joining(","));
    }

    private _CsvExport() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

