/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.metamodel;

import java.util.Optional;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.schema.metamodel.v2.Action;
import org.apache.isis.schema.metamodel.v2.Collection;
import org.apache.isis.schema.metamodel.v2.DomainClassDto;
import org.apache.isis.schema.metamodel.v2.FacetAttr;
import org.apache.isis.schema.metamodel.v2.FacetHolder;
import org.apache.isis.schema.metamodel.v2.MetamodelDto;
import org.apache.isis.schema.metamodel.v2.Property;
import org.springframework.lang.Nullable;

final class _AsciiExport {
    static StringBuilder toAscii(MetamodelDto metamodelDto) {
        StringBuilder sb = new StringBuilder();
        metamodelDto.getDomainClassDto().forEach(typeDto -> _AsciiExport.toAscii(typeDto, sb));
        return sb;
    }

    private static void toAscii(DomainClassDto typeDto, StringBuilder sb) {
        sb.append(typeDto.getId()).append("\n");
        _AsciiExport.toAscii("  * ", typeDto.getFacets(), sb);
        Optional.ofNullable(typeDto.getProperties()).map(props -> props.getProp()).ifPresent(list -> list.forEach(propDto -> _AsciiExport.toAscii(propDto, sb)));
        Optional.ofNullable(typeDto.getCollections()).map(colls -> colls.getColl()).ifPresent(list -> list.forEach(collDto -> _AsciiExport.toAscii(collDto, sb)));
        Optional.ofNullable(typeDto.getActions()).map(acts -> acts.getAct()).ifPresent(list -> list.forEach(actDto -> _AsciiExport.toAscii(actDto, sb)));
    }

    private static void toAscii(String prefix, @Nullable FacetHolder.Facets facets, StringBuilder sb) {
        String attrPrefix = _Strings.of((int)(prefix.length() - 2), (char)' ') + "  | ";
        Optional.ofNullable(facets).map(fac -> fac.getFacet()).ifPresent(list -> list.forEach(facetDto -> {
            sb.append(prefix).append(_AsciiExport.shorten(facetDto.getId())).append("\n");
            Optional.ofNullable(facetDto.getAttr()).ifPresent(attrs -> attrs.forEach(attr -> _AsciiExport.toAscii(attrPrefix, attr, sb)));
        }));
    }

    private static void toAscii(String attrPrefix, FacetAttr attr, StringBuilder sb) {
        if (attr.getName().equals("precedence") && attr.getValue().equals("DEFAULT")) {
            return;
        }
        sb.append(attrPrefix).append(attr.getName()).append('=').append(attr.getValue()).append("\n");
    }

    private static void toAscii(Property propDto, StringBuilder sb) {
        sb.append("+-- prop ").append(propDto.getId()).append("\n");
        _AsciiExport.toAscii("      * ", propDto.getFacets(), sb);
    }

    private static void toAscii(Collection collDto, StringBuilder sb) {
        sb.append("+-- coll ").append(collDto.getId()).append("\n");
        _AsciiExport.toAscii("      * ", collDto.getFacets(), sb);
    }

    private static void toAscii(Action actDto, StringBuilder sb) {
        sb.append("+-- act  ").append(actDto.getId()).append("\n");
        _AsciiExport.toAscii("      * ", actDto.getFacets(), sb);
    }

    private static String shorten(String id) {
        return id.replace("org.apache.isis.core.metamodel.facets", "..facets");
    }

    private _AsciiExport() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

