/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.metamodel;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.isis.applib.IsisModuleApplib;
import org.apache.isis.applib.annotation.Action;
import org.apache.isis.applib.annotation.ActionLayout;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.DomainServiceLayout;
import org.apache.isis.applib.annotation.MemberSupport;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Optionality;
import org.apache.isis.applib.annotation.Parameter;
import org.apache.isis.applib.annotation.ParameterLayout;
import org.apache.isis.applib.annotation.RestrictTo;
import org.apache.isis.applib.annotation.SemanticsOf;
import org.apache.isis.applib.services.jaxb.JaxbService;
import org.apache.isis.applib.services.metamodel.Config;
import org.apache.isis.applib.services.metamodel.DomainMember;
import org.apache.isis.applib.services.metamodel.DomainModel;
import org.apache.isis.applib.services.metamodel.MetaModelService;
import org.apache.isis.applib.services.metamodel._AsciiExport;
import org.apache.isis.applib.services.metamodel._CsvExport;
import org.apache.isis.applib.services.metamodel._DiffExport;
import org.apache.isis.applib.value.Blob;
import org.apache.isis.applib.value.Clob;
import org.apache.isis.applib.value.NamedWithMimeType;
import org.apache.isis.commons.internal.collections._Sets;
import org.apache.isis.schema.metamodel.v2.MetamodelDto;

@Named(value="isis.applib.MetaModelServiceMenu")
@DomainService(nature=NatureOfService.VIEW)
@DomainServiceLayout(named="Prototyping", menuBar=DomainServiceLayout.MenuBar.SECONDARY)
@Priority(value=0x1FFFFFFF)
public class MetaModelServiceMenu {
    static final String LOGICAL_TYPE_NAME = "isis.applib.MetaModelServiceMenu";
    @Inject
    MetaModelService metaModelService;
    @Inject
    JaxbService jaxbService;

    private Config defaultConfig(boolean includeInterfaces, List<String> namespaces) {
        Config config = Config.builder().ignoreFallbackFacets(true).ignoreAbstractClasses(true).ignoreBuiltInValueTypes(true).ignoreInterfaces(!includeInterfaces).build();
        for (String namespace : namespaces) {
            config = config.withNamespacePrefix(namespace);
        }
        return config;
    }

    private List<String> namespaceChoices() {
        DomainModel domainModel = this.metaModelService.getDomainModel();
        List<DomainMember> export = domainModel.getDomainMembers();
        TreeSet namespaces = _Sets.newTreeSet();
        for (DomainMember domainMember : export) {
            String namespace = domainMember.getNamespace();
            String[] split = namespace.split("[.]");
            StringBuilder buf = new StringBuilder();
            for (String part : split) {
                if (buf.length() > 0) {
                    buf.append(".");
                }
                buf.append(part);
                namespaces.add(buf.toString());
            }
        }
        return new ArrayList<String>(namespaces);
    }

    @Action(domainEvent=ActionDomainEvent.class, semantics=SemanticsOf.NON_IDEMPOTENT, restrictTo=RestrictTo.PROTOTYPING)
    @ActionLayout(cssClassFa="fa-download", named="Generate Meta Model Diff", sequence="500.500.2")
    public class downloadMetaModelDiff {
        @MemberSupport
        public Blob act(@ParameterLayout(named=".txt file name") String fileName, @ParameterLayout(named="Namespaces", describedAs="Subset of the complete meta model, only including namespaces starting with given prefix") List<String> namespaces, @ParameterLayout @Parameter(optionality=Optionality.MANDATORY) boolean includeInterfaces, @ParameterLayout(named="Metamodel (Zipped XML)", describedAs="Metamodel from a previous export, to compare the current with.") @Parameter(fileAccept=".zip", optionality=Optionality.MANDATORY) Blob zippedMetamodelBlob) throws IOException {
            Config config = MetaModelServiceMenu.this.defaultConfig(includeInterfaces, namespaces);
            MetamodelDto leftMetamodelDto = MetaModelServiceMenu.this.metaModelService.exportMetaModel(config);
            String xml = zippedMetamodelBlob.unZip(NamedWithMimeType.CommonMimeType.XML).toClob(StandardCharsets.UTF_8).getChars().toString();
            MetamodelDto rightMetamodelDto = MetaModelServiceMenu.this.jaxbService.fromXml(MetamodelDto.class, xml);
            StringBuilder diff = _DiffExport.toDiff(leftMetamodelDto, rightMetamodelDto);
            return Clob.of(fileName, NamedWithMimeType.CommonMimeType.TXT, diff).toBlob(StandardCharsets.UTF_8).zip();
        }

        @MemberSupport
        public String validateAct(String fileName, List<String> namespacePrefixes, boolean includeInterfaces, Blob rightMetamodelBlob) {
            if (namespacePrefixes == null || namespacePrefixes.isEmpty()) {
                return "At least one package must be selected";
            }
            return null;
        }

        @MemberSupport
        public String default0Act() {
            return "metamodel-diff.txt";
        }

        @MemberSupport
        public List<String> choices1Act() {
            return MetaModelServiceMenu.this.namespaceChoices();
        }

        @MemberSupport
        public boolean default2Act() {
            return false;
        }

        public class ActionDomainEvent
        extends org.apache.isis.applib.services.metamodel.MetaModelServiceMenu$ActionDomainEvent<downloadMetaModelDiff> {
        }
    }

    @Action(domainEvent=ActionDomainEvent.class, semantics=SemanticsOf.NON_IDEMPOTENT, restrictTo=RestrictTo.PROTOTYPING)
    @ActionLayout(cssClassFa="fa-download", named="Download Meta Model (Ascii)", sequence="500.500.2")
    public class downloadMetaModelAscii {
        @MemberSupport
        public Blob act(@ParameterLayout(named=".txt file name") String fileName, @ParameterLayout(named="Namespaces", describedAs="Subset of the complete meta model, only including namespaces starting with given prefix") List<String> namespaces, @ParameterLayout @Parameter(optionality=Optionality.MANDATORY) boolean includeInterfaces) {
            Config config = MetaModelServiceMenu.this.defaultConfig(includeInterfaces, namespaces);
            MetamodelDto metamodelDto = MetaModelServiceMenu.this.metaModelService.exportMetaModel(config);
            StringBuilder ascii = _AsciiExport.toAscii(metamodelDto);
            return Clob.of(fileName, NamedWithMimeType.CommonMimeType.TXT, ascii).toBlob(StandardCharsets.UTF_8).zip();
        }

        @MemberSupport
        public String validateAct(String fileName, List<String> namespacePrefixes, boolean includeInterfaces) {
            if (namespacePrefixes == null || namespacePrefixes.isEmpty()) {
                return "At least one package must be selected";
            }
            return null;
        }

        @MemberSupport
        public String default0Act() {
            return "metamodel.txt";
        }

        @MemberSupport
        public List<String> choices1Act() {
            return MetaModelServiceMenu.this.namespaceChoices();
        }

        @MemberSupport
        public boolean default2Act() {
            return false;
        }

        public class ActionDomainEvent
        extends org.apache.isis.applib.services.metamodel.MetaModelServiceMenu$ActionDomainEvent<downloadMetaModelAscii> {
        }
    }

    @Action(domainEvent=ActionDomainEvent.class, semantics=SemanticsOf.NON_IDEMPOTENT, restrictTo=RestrictTo.PROTOTYPING)
    @ActionLayout(cssClassFa="fa-download", named="Download Meta Model (XML)", sequence="500.500.2")
    public class downloadMetaModelXml {
        @MemberSupport
        public Blob act(@ParameterLayout(named=".xml file name") String fileName, @ParameterLayout(named="Namespaces", describedAs="Subset of the complete meta model, only including namespaces starting with given prefix") List<String> namespaces, @ParameterLayout @Parameter(optionality=Optionality.MANDATORY) boolean includeInterfaces) {
            Config config = MetaModelServiceMenu.this.defaultConfig(includeInterfaces, namespaces);
            MetamodelDto metamodelDto = MetaModelServiceMenu.this.metaModelService.exportMetaModel(config);
            String xml = MetaModelServiceMenu.this.jaxbService.toXml(metamodelDto);
            return Clob.of(fileName, NamedWithMimeType.CommonMimeType.XML, xml).toBlob(StandardCharsets.UTF_8).zip();
        }

        @MemberSupport
        public String validateAct(String fileName, List<String> namespacePrefixes, boolean includeInterfaces) {
            if (namespacePrefixes == null || namespacePrefixes.isEmpty()) {
                return "At least one package must be selected";
            }
            return null;
        }

        @MemberSupport
        public String default0Act() {
            return "metamodel.xml";
        }

        @MemberSupport
        public List<String> choices1Act() {
            return MetaModelServiceMenu.this.namespaceChoices();
        }

        @MemberSupport
        public boolean default2Act() {
            return false;
        }

        public class ActionDomainEvent
        extends org.apache.isis.applib.services.metamodel.MetaModelServiceMenu$ActionDomainEvent<downloadMetaModelXml> {
        }
    }

    @Action(domainEvent=ActionDomainEvent.class, semantics=SemanticsOf.NON_IDEMPOTENT, restrictTo=RestrictTo.PROTOTYPING)
    @ActionLayout(cssClassFa="fa-download", named="Download Meta Model (CSV)", sequence="500.500.2")
    public class downloadMetaModelCsv {
        @MemberSupport
        public Blob act(@ParameterLayout(named=".csv file name") String csvFileName) {
            DomainModel domainModel = MetaModelServiceMenu.this.metaModelService.getDomainModel();
            StringBuilder csv = _CsvExport.toCsv(domainModel);
            return Clob.of(csvFileName, NamedWithMimeType.CommonMimeType.CSV, csv).toBlob(StandardCharsets.UTF_8).zip();
        }

        @MemberSupport
        public String default0Act() {
            return "metamodel.csv";
        }

        public class ActionDomainEvent
        extends org.apache.isis.applib.services.metamodel.MetaModelServiceMenu$ActionDomainEvent<downloadMetaModelCsv> {
        }
    }

    public static abstract class ActionDomainEvent<T>
    extends IsisModuleApplib.ActionDomainEvent<T> {
    }
}

