/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.metamodel;

import java.util.Set;
import org.apache.isis.commons.internal.collections._Sets;

public class Config {
    private final boolean ignoreFallbackFacets;
    private final boolean ignoreInterfaces;
    private final boolean ignoreAbstractClasses;
    private final boolean ignoreBuiltInValueTypes;
    private final boolean ignoreMixins;
    private final boolean includeShadowedFacets;
    private final boolean includeTitleAnnotations;
    private final Set<String> namespacePrefixes;

    public boolean isNamespacePrefixAny() {
        return this.namespacePrefixes.isEmpty() || this.namespacePrefixes.contains("*");
    }

    public Config withNamespacePrefix(String namespace) {
        Config newConfig = this.asBuilder().build();
        newConfig.namespacePrefixes.add(namespace);
        return newConfig;
    }

    public ConfigBuilder asBuilder() {
        return Config.builder().ignoreFallbackFacets(this.ignoreFallbackFacets).ignoreInterfaces(this.ignoreInterfaces).ignoreAbstractClasses(this.ignoreAbstractClasses).ignoreBuiltInValueTypes(this.ignoreBuiltInValueTypes).ignoreMixins(this.ignoreMixins).includeShadowedFacets(this.includeShadowedFacets).includeTitleAnnotations(this.includeTitleAnnotations).namespacePrefixes(_Sets.newHashSet(this.namespacePrefixes));
    }

    private static Set<String> $default$namespacePrefixes() {
        return _Sets.newHashSet();
    }

    Config(boolean ignoreFallbackFacets, boolean ignoreInterfaces, boolean ignoreAbstractClasses, boolean ignoreBuiltInValueTypes, boolean ignoreMixins, boolean includeShadowedFacets, boolean includeTitleAnnotations, Set<String> namespacePrefixes) {
        this.ignoreFallbackFacets = ignoreFallbackFacets;
        this.ignoreInterfaces = ignoreInterfaces;
        this.ignoreAbstractClasses = ignoreAbstractClasses;
        this.ignoreBuiltInValueTypes = ignoreBuiltInValueTypes;
        this.ignoreMixins = ignoreMixins;
        this.includeShadowedFacets = includeShadowedFacets;
        this.includeTitleAnnotations = includeTitleAnnotations;
        this.namespacePrefixes = namespacePrefixes;
    }

    public static ConfigBuilder builder() {
        return new ConfigBuilder();
    }

    public boolean isIgnoreFallbackFacets() {
        return this.ignoreFallbackFacets;
    }

    public boolean isIgnoreInterfaces() {
        return this.ignoreInterfaces;
    }

    public boolean isIgnoreAbstractClasses() {
        return this.ignoreAbstractClasses;
    }

    public boolean isIgnoreBuiltInValueTypes() {
        return this.ignoreBuiltInValueTypes;
    }

    public boolean isIgnoreMixins() {
        return this.ignoreMixins;
    }

    public boolean isIncludeShadowedFacets() {
        return this.includeShadowedFacets;
    }

    public boolean isIncludeTitleAnnotations() {
        return this.includeTitleAnnotations;
    }

    public Set<String> getNamespacePrefixes() {
        return this.namespacePrefixes;
    }

    public static class ConfigBuilder {
        private boolean ignoreFallbackFacets;
        private boolean ignoreInterfaces;
        private boolean ignoreAbstractClasses;
        private boolean ignoreBuiltInValueTypes;
        private boolean ignoreMixins;
        private boolean includeShadowedFacets;
        private boolean includeTitleAnnotations;
        private boolean namespacePrefixes$set;
        private Set<String> namespacePrefixes$value;

        ConfigBuilder() {
        }

        public ConfigBuilder ignoreFallbackFacets(boolean ignoreFallbackFacets) {
            this.ignoreFallbackFacets = ignoreFallbackFacets;
            return this;
        }

        public ConfigBuilder ignoreInterfaces(boolean ignoreInterfaces) {
            this.ignoreInterfaces = ignoreInterfaces;
            return this;
        }

        public ConfigBuilder ignoreAbstractClasses(boolean ignoreAbstractClasses) {
            this.ignoreAbstractClasses = ignoreAbstractClasses;
            return this;
        }

        public ConfigBuilder ignoreBuiltInValueTypes(boolean ignoreBuiltInValueTypes) {
            this.ignoreBuiltInValueTypes = ignoreBuiltInValueTypes;
            return this;
        }

        public ConfigBuilder ignoreMixins(boolean ignoreMixins) {
            this.ignoreMixins = ignoreMixins;
            return this;
        }

        public ConfigBuilder includeShadowedFacets(boolean includeShadowedFacets) {
            this.includeShadowedFacets = includeShadowedFacets;
            return this;
        }

        public ConfigBuilder includeTitleAnnotations(boolean includeTitleAnnotations) {
            this.includeTitleAnnotations = includeTitleAnnotations;
            return this;
        }

        public ConfigBuilder namespacePrefixes(Set<String> namespacePrefixes) {
            this.namespacePrefixes$value = namespacePrefixes;
            this.namespacePrefixes$set = true;
            return this;
        }

        public Config build() {
            Set<String> namespacePrefixes$value = this.namespacePrefixes$value;
            if (!this.namespacePrefixes$set) {
                namespacePrefixes$value = Config.$default$namespacePrefixes();
            }
            return new Config(this.ignoreFallbackFacets, this.ignoreInterfaces, this.ignoreAbstractClasses, this.ignoreBuiltInValueTypes, this.ignoreMixins, this.includeShadowedFacets, this.includeTitleAnnotations, namespacePrefixes$value);
        }

        public String toString() {
            return "Config.ConfigBuilder(ignoreFallbackFacets=" + this.ignoreFallbackFacets + ", ignoreInterfaces=" + this.ignoreInterfaces + ", ignoreAbstractClasses=" + this.ignoreAbstractClasses + ", ignoreBuiltInValueTypes=" + this.ignoreBuiltInValueTypes + ", ignoreMixins=" + this.ignoreMixins + ", includeShadowedFacets=" + this.includeShadowedFacets + ", includeTitleAnnotations=" + this.includeTitleAnnotations + ", namespacePrefixes$value=" + this.namespacePrefixes$value + ")";
        }
    }
}

