/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.metamodel;

public enum BeanSort {
    VIEW_MODEL,
    ENTITY,
    MANAGED_BEAN_CONTRIBUTING,
    MANAGED_BEAN_NOT_CONTRIBUTING,
    MIXIN,
    VALUE,
    COLLECTION,
    ABSTRACT,
    VETOED,
    UNKNOWN;


    public boolean isManagedBeanContributing() {
        return this == MANAGED_BEAN_CONTRIBUTING;
    }

    public boolean isManagedBeanNotContributing() {
        return this == MANAGED_BEAN_NOT_CONTRIBUTING;
    }

    public boolean isManagedBeanAny() {
        return this == MANAGED_BEAN_CONTRIBUTING || this == MANAGED_BEAN_NOT_CONTRIBUTING;
    }

    public boolean isMixin() {
        return this == MIXIN;
    }

    public boolean isViewModel() {
        return this == VIEW_MODEL;
    }

    public boolean isValue() {
        return this == VALUE;
    }

    public boolean isCollection() {
        return this == COLLECTION;
    }

    public boolean isEntity() {
        return this == ENTITY;
    }

    public boolean isAbstract() {
        return this == ABSTRACT;
    }

    public boolean isVetoed() {
        return this == VETOED;
    }

    public boolean isUnknown() {
        return this == UNKNOWN;
    }

    public boolean isToBeIntrospected() {
        if (this.isVetoed() || this.isUnknown() || this.isCollection()) {
            return false;
        }
        return this != MANAGED_BEAN_NOT_CONTRIBUTING;
    }

    public boolean isWrappingSupported() {
        return this.isMixin() || this.isViewModel() || this.isEntity() || this.isManagedBeanAny();
    }
}

