/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.layout;

import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import javax.annotation.Priority;
import javax.inject.Named;
import org.apache.isis.applib.IsisModuleApplib;
import org.apache.isis.applib.annotation.Action;
import org.apache.isis.applib.annotation.ActionLayout;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.DomainServiceLayout;
import org.apache.isis.applib.annotation.MemberSupport;
import org.apache.isis.applib.annotation.ParameterLayout;
import org.apache.isis.applib.annotation.RestrictTo;
import org.apache.isis.applib.annotation.SemanticsOf;
import org.apache.isis.applib.services.layout.LayoutExportStyle;
import org.apache.isis.applib.services.layout.LayoutService;
import org.apache.isis.applib.services.menu.MenuBarsService;
import org.apache.isis.applib.value.Blob;
import org.apache.isis.applib.value.Clob;
import org.apache.isis.commons.internal.base._Strings;

@Named(value="isis.applib.LayoutServiceMenu")
@DomainService
@DomainServiceLayout(named="Prototyping", menuBar=DomainServiceLayout.MenuBar.SECONDARY)
@Priority(value=0x1FFFFFFF)
public class LayoutServiceMenu {
    public static final String LOGICAL_TYPE_NAME = "isis.applib.LayoutServiceMenu";
    private final LayoutService layoutService;
    private final MimeType mimeTypeApplicationZip;

    public LayoutServiceMenu(LayoutService layoutService) {
        this.layoutService = layoutService;
        try {
            this.mimeTypeApplicationZip = new MimeType("application", "zip");
        }
        catch (MimeTypeParseException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Action(domainEvent=ActionDomainEvent.class, semantics=SemanticsOf.NON_IDEMPOTENT, restrictTo=RestrictTo.PROTOTYPING)
    @ActionLayout(cssClassFa="fa-download", named="Download Menu Bars Layout (XML)", sequence="500.400.2")
    public class downloadMenuBarsLayout {
        @MemberSupport
        public Clob act(@ParameterLayout(named="File name") String fileName, MenuBarsService.Type type) {
            String xml = LayoutServiceMenu.this.layoutService.toMenuBarsXml(type);
            return new Clob(_Strings.asFileNameWithExtension((String)fileName, (String)".xml"), "text/xml", (CharSequence)xml);
        }

        @MemberSupport
        public String default0Act() {
            return "menubars.layout.xml";
        }

        @MemberSupport
        public MenuBarsService.Type default1Act() {
            return MenuBarsService.Type.DEFAULT;
        }

        public class ActionDomainEvent
        extends org.apache.isis.applib.services.layout.LayoutServiceMenu$ActionDomainEvent<downloadMenuBarsLayout> {
        }
    }

    @Action(domainEvent=ActionDomainEvent.class, semantics=SemanticsOf.NON_IDEMPOTENT, restrictTo=RestrictTo.PROTOTYPING)
    @ActionLayout(cssClassFa="fa-download", named="Download Object Layouts (ZIP)", sequence="500.400.1")
    public class downloadLayouts {
        @MemberSupport
        public Blob act(LayoutExportStyle style) {
            String fileName = "layouts." + style.name().toLowerCase() + ".zip";
            byte[] zipBytes = LayoutServiceMenu.this.layoutService.toZip(style);
            return new Blob(fileName, LayoutServiceMenu.this.mimeTypeApplicationZip, zipBytes);
        }

        @MemberSupport
        public LayoutExportStyle default0Act() {
            return LayoutExportStyle.defaults();
        }

        public class ActionDomainEvent
        extends org.apache.isis.applib.services.layout.LayoutServiceMenu$ActionDomainEvent<downloadLayouts> {
        }
    }

    public static abstract class ActionDomainEvent<T>
    extends IsisModuleApplib.ActionDomainEvent<T> {
    }
}

