/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.keyvaluestore;

import java.io.Serializable;
import java.util.Optional;
import lombok.NonNull;
import org.springframework.lang.Nullable;

public interface KeyValueSessionStore {
    public boolean isSessionAvailable();

    public void put(@NonNull String var1, @Nullable Serializable var2);

    public <T extends Serializable> Optional<T> lookupAs(@NonNull String var1, @NonNull Class<T> var2);

    public void clear(@NonNull String var1);

    default public Optional<String> lookupAsString(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.lookupAs(key, String.class);
    }

    default public boolean getAsBoolean(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.lookupAs(key, Boolean.class).map(Boolean::booleanValue).orElse(false);
    }
}

