/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.jaxb;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.bind.Unmarshaller;
import lombok.NonNull;
import org.apache.isis.applib.services.jaxb.CatalogingSchemaOutputResolver;
import org.apache.isis.applib.services.jaxb.IsisSchemas;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.resources._Xml;
import org.springframework.lang.Nullable;

public interface JaxbService {
    default public Object fromXml(JAXBContext jaxbContext, String xml) {
        return this.fromXml(jaxbContext, xml, null);
    }

    public Object fromXml(JAXBContext var1, String var2, @Nullable Map<String, Object> var3);

    default public <T> T fromXml(Class<T> domainClass, String xml) {
        return this.fromXml(domainClass, xml, null);
    }

    public <T> T fromXml(Class<T> var1, String var2, @Nullable Map<String, Object> var3);

    default public String toXml(Object domainObject) {
        return this.toXml(domainObject, null);
    }

    public String toXml(Object var1, @Nullable Map<String, Object> var2);

    public Map<String, String> toXsd(Object var1, IsisSchemas var2);

    public static class Simple
    implements JaxbService {
        @Override
        @Nullable
        public final Object fromXml(@NonNull JAXBContext jaxbContext, @Nullable String xml, @Nullable Map<String, Object> unmarshallerProperties) {
            if (jaxbContext == null) {
                throw new NullPointerException("jaxbContext is marked non-null but is null");
            }
            try {
                return this.internalFromXml(jaxbContext, xml, unmarshallerProperties);
            }
            catch (Exception e) {
                throw _Xml.verboseException((String)"unmarshalling XML", null, (Exception)e);
            }
        }

        @Override
        @Nullable
        public final <T> T fromXml(@NonNull Class<T> domainClass, @Nullable String xml, @Nullable Map<String, Object> unmarshallerProperties) {
            if (domainClass == null) {
                throw new NullPointerException("domainClass is marked non-null but is null");
            }
            try {
                JAXBContext jaxbContext = this.jaxbContextForClass(domainClass);
                return (T)_Casts.uncheckedCast((Object)this.internalFromXml(jaxbContext, xml, unmarshallerProperties));
            }
            catch (Exception e) {
                throw _Xml.verboseException((String)"unmarshalling XML", domainClass, (Exception)e);
            }
        }

        @Override
        public final String toXml(@NonNull Object domainObject, @Nullable Map<String, Object> marshallerProperties) {
            if (domainObject == null) {
                throw new NullPointerException("domainObject is marked non-null but is null");
            }
            Class<?> domainClass = domainObject.getClass();
            JAXBContext jaxbContext = this.jaxbContextForObject(domainObject);
            try {
                Marshaller marshaller = jaxbContext.createMarshaller();
                marshaller.setProperty("jaxb.formatted.output", (Object)true);
                for (Map.Entry entry : _NullSafe.entrySet(marshallerProperties)) {
                    marshaller.setProperty((String)entry.getKey(), entry.getValue());
                }
                this.configure(marshaller);
                StringWriter writer = new StringWriter();
                marshaller.marshal(domainObject, (Writer)writer);
                String xml = writer.toString();
                return xml;
            }
            catch (Exception e) {
                throw _Xml.verboseException((String)"marshalling domain object to XML", domainClass, (Exception)e);
            }
        }

        protected JAXBContext jaxbContextForObject(@NonNull Object domainObject) {
            if (domainObject == null) {
                throw new NullPointerException("domainObject is marked non-null but is null");
            }
            boolean useCache = true;
            return _Xml.jaxbContextFor(domainObject.getClass(), (boolean)true);
        }

        protected JAXBContext jaxbContextForClass(@NonNull Class<?> domainObjectClass) {
            if (domainObjectClass == null) {
                throw new NullPointerException("domainObjectClass is marked non-null but is null");
            }
            boolean useCache = true;
            return _Xml.jaxbContextFor(domainObjectClass, (boolean)true);
        }

        protected void configure(Unmarshaller unmarshaller) {
        }

        protected void configure(Marshaller marshaller) {
        }

        @Nullable
        protected Object internalFromXml(@NonNull JAXBContext jaxbContext, @Nullable String xml, @Nullable Map<String, Object> unmarshallerProperties) throws JAXBException {
            if (jaxbContext == null) {
                throw new NullPointerException("jaxbContext is marked non-null but is null");
            }
            if (xml == null) {
                return null;
            }
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            for (Map.Entry entry : _NullSafe.entrySet(unmarshallerProperties)) {
                unmarshaller.setProperty((String)entry.getKey(), entry.getValue());
            }
            this.configure(unmarshaller);
            Object pojo = unmarshaller.unmarshal((Reader)new StringReader(xml));
            return pojo;
        }

        @Override
        public final Map<String, String> toXsd(@NonNull Object domainObject, @NonNull IsisSchemas isisSchemas) {
            if (domainObject == null) {
                throw new NullPointerException("domainObject is marked non-null but is null");
            }
            if (isisSchemas == null) {
                throw new NullPointerException("isisSchemas is marked non-null but is null");
            }
            JAXBContext jaxbContext = this.jaxbContextForObject(domainObject);
            CatalogingSchemaOutputResolver outputResolver = new CatalogingSchemaOutputResolver(isisSchemas);
            jaxbContext.generateSchema((SchemaOutputResolver)outputResolver);
            return outputResolver.asMap();
        }
    }
}

