/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.iactnlayer;

import java.util.concurrent.Callable;
import lombok.NonNull;
import org.apache.isis.applib.services.iactnlayer.InteractionContext;
import org.apache.isis.applib.services.iactnlayer.InteractionLayer;
import org.apache.isis.applib.services.iactnlayer.InteractionLayerTracker;
import org.apache.isis.commons.functional.ThrowingRunnable;
import org.apache.isis.commons.functional.Try;

public interface InteractionService
extends InteractionLayerTracker {
    public InteractionLayer openInteraction();

    public InteractionLayer openInteraction(@NonNull InteractionContext var1);

    public void closeInteractionLayers();

    @Override
    public boolean isInInteraction();

    public <R> R call(@NonNull InteractionContext var1, @NonNull Callable<R> var2);

    public void run(@NonNull InteractionContext var1, @NonNull ThrowingRunnable var2);

    public <R> R callAnonymous(@NonNull Callable<R> var1);

    public void runAnonymous(@NonNull ThrowingRunnable var1);

    default public <R> Try<R> callAndCatch(@NonNull InteractionContext interactionContext, @NonNull Callable<R> callable) {
        if (interactionContext == null) {
            throw new NullPointerException("interactionContext is marked non-null but is null");
        }
        if (callable == null) {
            throw new NullPointerException("callable is marked non-null but is null");
        }
        return Try.call(() -> this.call(interactionContext, callable));
    }

    default public Try<Void> runAndCatch(@NonNull InteractionContext interactionContext, @NonNull ThrowingRunnable runnable) {
        if (interactionContext == null) {
            throw new NullPointerException("interactionContext is marked non-null but is null");
        }
        if (runnable == null) {
            throw new NullPointerException("runnable is marked non-null but is null");
        }
        return this.callAndCatch(interactionContext, ThrowingRunnable.toCallable((ThrowingRunnable)runnable));
    }

    default public <R> Try<R> callAnonymousAndCatch(@NonNull Callable<R> callable) {
        if (callable == null) {
            throw new NullPointerException("callable is marked non-null but is null");
        }
        return Try.call(() -> this.callAnonymous(callable));
    }

    default public Try<Void> runAnonymousAndCatch(@NonNull ThrowingRunnable runnable) {
        if (runnable == null) {
            throw new NullPointerException("runnable is marked non-null but is null");
        }
        return this.callAnonymousAndCatch(ThrowingRunnable.toCallable((ThrowingRunnable)runnable));
    }

    default public InteractionLayer nextInteraction() {
        this.closeInteractionLayers();
        return this.openInteraction();
    }

    default public InteractionLayer nextInteraction(InteractionContext interactionContext) {
        this.closeInteractionLayers();
        return this.openInteraction(interactionContext);
    }
}

