/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.iactnlayer;

import java.io.Serializable;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Optional;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import lombok.NonNull;
import org.apache.isis.applib.clock.VirtualClock;
import org.apache.isis.applib.locale.UserLocale;
import org.apache.isis.applib.services.user.UserMemento;

public class InteractionContext
implements Serializable {
    private static final long serialVersionUID = -220896735209733865L;
    @NonNull
    private final UserMemento user;
    @NonNull
    private final VirtualClock clock;
    private UserLocale locale;
    @NonNull
    private final ZoneId timeZone;

    public static InteractionContext ofUserWithSystemDefaults(@NonNull UserMemento user) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        return InteractionContext.builder().user(user).clock(VirtualClock.system()).timeZone(ZoneId.systemDefault()).build();
    }

    public UserLocale getLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        return Optional.ofNullable(this.getUser()).map(UserMemento::asUserLocale).orElseGet(UserLocale::getDefault);
    }

    public InteractionContext withTimeZoneIfAny(Optional<ZoneId> zoneIdIfAny) {
        return zoneIdIfAny.map(this::withTimeZone).orElse(this);
    }

    public static UnaryOperator<InteractionContext> switchUser(@NonNull UserMemento userMemento) {
        if (userMemento == null) {
            throw new NullPointerException("userMemento is marked non-null but is null");
        }
        return interactionContext -> interactionContext.withUser(userMemento);
    }

    public static UnaryOperator<InteractionContext> switchClock(@NonNull VirtualClock clock) {
        if (clock == null) {
            throw new NullPointerException("clock is marked non-null but is null");
        }
        return interactionContext -> interactionContext.withClock(clock);
    }

    public static UnaryOperator<InteractionContext> switchLocale(@NonNull UserLocale locale) {
        if (locale == null) {
            throw new NullPointerException("locale is marked non-null but is null");
        }
        return interactionContext -> interactionContext.withLocale(locale);
    }

    public static UnaryOperator<InteractionContext> switchTimeZone(@NonNull ZoneId timeZone) {
        if (timeZone == null) {
            throw new NullPointerException("timeZone is marked non-null but is null");
        }
        return interactionContext -> interactionContext.withTimeZone(timeZone);
    }

    @SafeVarargs
    public static <T> UnaryOperator<T> combine(UnaryOperator<T> ... mappers) {
        return InteractionContext.combine(Stream.of(mappers));
    }

    public static <T> UnaryOperator<T> combine(Stream<UnaryOperator<T>> mappers) {
        return mappers.reduce(t -> t, (a, b) -> a.andThen(b)::apply);
    }

    public ZoneOffset getTimeZoneOffsetNow() {
        return this.getTimeZone().getRules().getOffset(Instant.now());
    }

    private static UserMemento $default$user() {
        return UserMemento.system();
    }

    private static VirtualClock $default$clock() {
        return VirtualClock.system();
    }

    private static ZoneId $default$timeZone() {
        return ZoneId.systemDefault();
    }

    InteractionContext(@NonNull UserMemento user, @NonNull VirtualClock clock, UserLocale locale, @NonNull ZoneId timeZone) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (clock == null) {
            throw new NullPointerException("clock is marked non-null but is null");
        }
        if (timeZone == null) {
            throw new NullPointerException("timeZone is marked non-null but is null");
        }
        this.user = user;
        this.clock = clock;
        this.locale = locale;
        this.timeZone = timeZone;
    }

    public static InteractionContextBuilder builder() {
        return new InteractionContextBuilder();
    }

    public String toString() {
        return "InteractionContext(user=" + this.getUser() + ", clock=" + this.getClock() + ", locale=" + this.getLocale() + ", timeZone=" + this.getTimeZone() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InteractionContext)) {
            return false;
        }
        InteractionContext other = (InteractionContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UserMemento this$user = this.getUser();
        UserMemento other$user = other.getUser();
        if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
            return false;
        }
        VirtualClock this$clock = this.getClock();
        VirtualClock other$clock = other.getClock();
        if (this$clock == null ? other$clock != null : !this$clock.equals(other$clock)) {
            return false;
        }
        UserLocale this$locale = this.getLocale();
        UserLocale other$locale = other.getLocale();
        if (this$locale == null ? other$locale != null : !((Object)this$locale).equals(other$locale)) {
            return false;
        }
        ZoneId this$timeZone = this.getTimeZone();
        ZoneId other$timeZone = other.getTimeZone();
        return !(this$timeZone == null ? other$timeZone != null : !((Object)this$timeZone).equals(other$timeZone));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InteractionContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UserMemento $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
        VirtualClock $clock = this.getClock();
        result = result * 59 + ($clock == null ? 43 : $clock.hashCode());
        UserLocale $locale = this.getLocale();
        result = result * 59 + ($locale == null ? 43 : ((Object)$locale).hashCode());
        ZoneId $timeZone = this.getTimeZone();
        result = result * 59 + ($timeZone == null ? 43 : ((Object)$timeZone).hashCode());
        return result;
    }

    public InteractionContext withUser(@NonNull UserMemento user) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        return this.user == user ? this : new InteractionContext(user, this.clock, this.locale, this.timeZone);
    }

    @NonNull
    public UserMemento getUser() {
        return this.user;
    }

    public InteractionContext withClock(@NonNull VirtualClock clock) {
        if (clock == null) {
            throw new NullPointerException("clock is marked non-null but is null");
        }
        return this.clock == clock ? this : new InteractionContext(this.user, clock, this.locale, this.timeZone);
    }

    @NonNull
    public VirtualClock getClock() {
        return this.clock;
    }

    public InteractionContext withLocale(UserLocale locale) {
        return this.locale == locale ? this : new InteractionContext(this.user, this.clock, locale, this.timeZone);
    }

    public InteractionContext withTimeZone(@NonNull ZoneId timeZone) {
        if (timeZone == null) {
            throw new NullPointerException("timeZone is marked non-null but is null");
        }
        return this.timeZone == timeZone ? this : new InteractionContext(this.user, this.clock, this.locale, timeZone);
    }

    @NonNull
    public ZoneId getTimeZone() {
        return this.timeZone;
    }

    public static class InteractionContextBuilder {
        private boolean user$set;
        private UserMemento user$value;
        private boolean clock$set;
        private VirtualClock clock$value;
        private UserLocale locale;
        private boolean timeZone$set;
        private ZoneId timeZone$value;

        InteractionContextBuilder() {
        }

        public InteractionContextBuilder user(@NonNull UserMemento user) {
            if (user == null) {
                throw new NullPointerException("user is marked non-null but is null");
            }
            this.user$value = user;
            this.user$set = true;
            return this;
        }

        public InteractionContextBuilder clock(@NonNull VirtualClock clock) {
            if (clock == null) {
                throw new NullPointerException("clock is marked non-null but is null");
            }
            this.clock$value = clock;
            this.clock$set = true;
            return this;
        }

        public InteractionContextBuilder locale(UserLocale locale) {
            this.locale = locale;
            return this;
        }

        public InteractionContextBuilder timeZone(@NonNull ZoneId timeZone) {
            if (timeZone == null) {
                throw new NullPointerException("timeZone is marked non-null but is null");
            }
            this.timeZone$value = timeZone;
            this.timeZone$set = true;
            return this;
        }

        public InteractionContext build() {
            UserMemento user$value = this.user$value;
            if (!this.user$set) {
                user$value = InteractionContext.$default$user();
            }
            VirtualClock clock$value = this.clock$value;
            if (!this.clock$set) {
                clock$value = InteractionContext.$default$clock();
            }
            ZoneId timeZone$value = this.timeZone$value;
            if (!this.timeZone$set) {
                timeZone$value = InteractionContext.$default$timeZone();
            }
            return new InteractionContext(user$value, clock$value, this.locale, timeZone$value);
        }

        public String toString() {
            return "InteractionContext.InteractionContextBuilder(user$value=" + this.user$value + ", clock$value=" + this.clock$value + ", locale=" + this.locale + ", timeZone$value=" + this.timeZone$value + ")";
        }
    }
}

