/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.iactn;

import java.sql.Timestamp;
import java.util.Collections;
import java.util.List;
import org.apache.isis.applib.Identifier;
import org.apache.isis.applib.events.domain.AbstractDomainEvent;
import org.apache.isis.applib.jaxb.JavaSqlXMLGregorianCalendarMarshalling;
import org.apache.isis.applib.services.clock.ClockService;
import org.apache.isis.applib.services.iactn.Interaction;
import org.apache.isis.applib.services.metrics.MetricsService;
import org.apache.isis.applib.util.schema.MemberExecutionDtoUtils;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.schema.common.v2.DifferenceDto;
import org.apache.isis.schema.common.v2.InteractionType;
import org.apache.isis.schema.common.v2.PeriodDto;
import org.apache.isis.schema.ixn.v2.MemberExecutionDto;
import org.apache.isis.schema.ixn.v2.MetricsDto;
import org.apache.isis.schema.ixn.v2.ObjectCountsDto;

public abstract class Execution<T extends MemberExecutionDto, E extends AbstractDomainEvent<?>> {
    private final Interaction interaction;
    private final InteractionType interactionType;
    private final Identifier logicalMemberIdentifier;
    private final Object target;
    private int numberObjectsLoadedBefore;
    private int numberObjectsDirtiedBefore;
    private final List<Execution<?, ?>> children = _Lists.newArrayList();
    private Execution<?, ?> parent;
    private E event;
    private Timestamp startedAt;
    private Timestamp completedAt;
    private Object returned;
    private Exception threw;
    private T dto;

    protected Execution(Interaction interaction, InteractionType interactionType, Identifier logicalMemberIdentifier, Object target) {
        this.interaction = interaction;
        this.interactionType = interactionType;
        this.logicalMemberIdentifier = logicalMemberIdentifier;
        this.target = target;
    }

    public void setParent(Execution<?, ?> parent) {
        this.parent = parent;
        if (parent != null) {
            parent.children.add(this);
        }
    }

    public List<Execution<?, ?>> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public void setEvent(E event) {
        this.event = event;
    }

    public Timestamp start(ClockService clockService, MetricsService metricsService) {
        Timestamp startedAt = clockService.getClock().nowAsJavaSqlTimestamp();
        this.syncMetrics(When.BEFORE, startedAt, metricsService);
        return startedAt;
    }

    public void setCompletedAt(Timestamp completedAt, MetricsService metricsService) {
        this.syncMetrics(When.AFTER, completedAt, metricsService);
    }

    public void setReturned(Object returned) {
        this.returned = returned;
    }

    public void setThrew(Exception threw) {
        this.threw = threw;
    }

    public void setDto(T executionDto) {
        this.dto = executionDto;
    }

    private void syncMetrics(When when, Timestamp timestamp, MetricsService metricsService) {
        int numberObjectsLoaded = metricsService.numberEntitiesLoaded();
        int numberObjectsDirtied = metricsService.numberEntitiesDirtied();
        when.syncMetrics(this, timestamp, numberObjectsLoaded, numberObjectsDirtied);
    }

    public Interaction getInteraction() {
        return this.interaction;
    }

    public InteractionType getInteractionType() {
        return this.interactionType;
    }

    public Identifier getLogicalMemberIdentifier() {
        return this.logicalMemberIdentifier;
    }

    public Object getTarget() {
        return this.target;
    }

    public Execution<?, ?> getParent() {
        return this.parent;
    }

    public E getEvent() {
        return this.event;
    }

    public Timestamp getStartedAt() {
        return this.startedAt;
    }

    public Timestamp getCompletedAt() {
        return this.completedAt;
    }

    public Object getReturned() {
        return this.returned;
    }

    public Exception getThrew() {
        return this.threw;
    }

    public T getDto() {
        return this.dto;
    }

    static enum When {
        BEFORE{

            @Override
            void syncMetrics(Execution<?, ?> execution, Timestamp timestamp, int numberObjectsLoaded, int numberObjectsDirtied) {
                execution.startedAt = timestamp;
                execution.numberObjectsLoadedBefore = numberObjectsLoaded;
                execution.numberObjectsDirtiedBefore = numberObjectsLoaded;
            }
        }
        ,
        AFTER{

            @Override
            void syncMetrics(Execution<?, ?> execution, Timestamp timestamp, int numberObjectsLoaded, int numberObjectsDirtied) {
                execution.completedAt = timestamp;
                if (execution.dto == null) {
                    return;
                }
                MetricsDto metricsDto = When.metricsFor(execution);
                PeriodDto periodDto = When.timingsFor(metricsDto);
                periodDto.setStartedAt(JavaSqlXMLGregorianCalendarMarshalling.toXMLGregorianCalendar(execution.startedAt));
                periodDto.setCompletedAt(JavaSqlXMLGregorianCalendarMarshalling.toXMLGregorianCalendar(execution.completedAt));
                ObjectCountsDto objectCountsDto = When.objectCountsFor(metricsDto);
                When.numberObjectsLoadedFor(objectCountsDto).setBefore(Integer.valueOf(execution.numberObjectsLoadedBefore));
                When.numberObjectsDirtiedFor(objectCountsDto).setBefore(Integer.valueOf(execution.numberObjectsDirtiedBefore));
                When.numberObjectsLoadedFor(objectCountsDto).setAfter(Integer.valueOf(numberObjectsLoaded));
                When.numberObjectsDirtiedFor(objectCountsDto).setAfter(Integer.valueOf(numberObjectsDirtied));
            }
        };


        private static DifferenceDto numberObjectsDirtiedFor(ObjectCountsDto objectCountsDto) {
            return MemberExecutionDtoUtils.numberObjectsDirtiedFor(objectCountsDto);
        }

        private static DifferenceDto numberObjectsLoadedFor(ObjectCountsDto objectCountsDto) {
            return MemberExecutionDtoUtils.numberObjectsLoadedFor(objectCountsDto);
        }

        private static ObjectCountsDto objectCountsFor(MetricsDto metricsDto) {
            return MemberExecutionDtoUtils.objectCountsFor(metricsDto);
        }

        private static MetricsDto metricsFor(Execution<?, ?> execution) {
            return MemberExecutionDtoUtils.metricsFor(execution.dto);
        }

        private static PeriodDto timingsFor(MetricsDto metricsDto) {
            return MemberExecutionDtoUtils.timingsFor(metricsDto);
        }

        abstract void syncMetrics(Execution<?, ?> var1, Timestamp var2, int var3, int var4);
    }
}

