/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.i18n;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.apache.isis.commons.internal.base._Strings;
import org.springframework.lang.Nullable;

public final class TranslationContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private static final TranslationContext EMPTY = TranslationContext.named("default");

    public static TranslationContext forClassName(@Nullable Class<?> contextClass) {
        return contextClass != null ? TranslationContext.named(contextClass.getName()) : EMPTY;
    }

    public static TranslationContext forMethod(@Nullable Class<?> contextClass, @Nullable String contextMethodName) {
        TranslationContext classContext = TranslationContext.forClassName(contextClass);
        return _Strings.isNullOrEmpty((CharSequence)contextMethodName) ? classContext : TranslationContext.named(classContext.getName() + "#" + contextMethodName + "()");
    }

    public static TranslationContext forMethod(@Nullable Method method) {
        return method != null ? TranslationContext.named(method.getDeclaringClass().getName() + "#" + method.getName() + "()") : EMPTY;
    }

    public static TranslationContext forEnum(@Nullable Enum<?> objectAsEnum) {
        return objectAsEnum != null ? TranslationContext.named(objectAsEnum.getClass().getName() + "#" + objectAsEnum.name()) : EMPTY;
    }

    public static TranslationContext empty() {
        return EMPTY;
    }

    private TranslationContext(String name) {
        this.name = name;
    }

    public static TranslationContext named(String name) {
        return new TranslationContext(name);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TranslationContext)) {
            return false;
        }
        TranslationContext other = (TranslationContext)o;
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public String toString() {
        return "TranslationContext(name=" + this.getName() + ")";
    }

    public String getName() {
        return this.name;
    }
}

