/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.grid;

import org.apache.isis.applib.layout.grid.Grid;
import org.apache.isis.applib.services.layout.LayoutExportStyle;
import org.apache.isis.commons.internal.exceptions._Exceptions;

public interface GridService {
    public boolean supportsReloading();

    public void remove(Class<?> var1);

    public boolean existsFor(Class<?> var1);

    public Grid load(Class<?> var1);

    public Grid load(Class<?> var1, String var2);

    public Grid defaultGridFor(Class<?> var1);

    public Grid normalize(Grid var1);

    public Grid complete(Grid var1);

    public Grid minimal(Grid var1);

    default public Grid toGridForExport(Class<?> domainClass, LayoutExportStyle style) {
        Grid grid = this.load(domainClass);
        if (grid == null) {
            grid = this.defaultGridFor(domainClass);
        }
        grid = this.normalize(grid);
        if (style == LayoutExportStyle.COMPLETE) {
            return this.complete(grid);
        }
        if (style == LayoutExportStyle.MINIMAL) {
            return this.minimal(grid);
        }
        throw _Exceptions.unmatchedCase((Object)((Object)style));
    }
}

