/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.exceprecog;

import java.util.Optional;
import lombok.NonNull;
import org.apache.isis.applib.services.exceprecog.Category;
import org.apache.isis.applib.services.i18n.TranslationContext;
import org.apache.isis.applib.services.i18n.TranslationService;
import org.springframework.lang.Nullable;

public final class Recognition {
    @NonNull
    private final Category category;
    @NonNull
    private final String reason;

    public static Optional<Recognition> of(@Nullable Category category, @Nullable String reason) {
        if (reason == null) {
            return Optional.empty();
        }
        Category nonNullCategory = category != null ? category : Category.OTHER;
        return Optional.of(new Recognition(nonNullCategory, reason));
    }

    public String toMessage(@Nullable TranslationService translationService) {
        String categoryLiteral = Recognition.translate(this.getCategory().getFriendlyName(), translationService);
        String reasonLiteral = Recognition.translate(this.getReason(), translationService);
        return String.format("[%s]: %s", categoryLiteral, reasonLiteral);
    }

    public String toMessageNoCategory(@Nullable TranslationService translationService) {
        String reasonLiteral = Recognition.translate(this.getReason(), translationService);
        return String.format("%s", reasonLiteral);
    }

    private static String translate(@Nullable String text, @Nullable TranslationService translationService) {
        if (text == null || translationService == null) {
            return text;
        }
        TranslationContext context = TranslationContext.forClassName(Recognition.class);
        return translationService.translate(context, text);
    }

    public Recognition(@NonNull Category category, @NonNull String reason) {
        if (category == null) {
            throw new NullPointerException("category is marked non-null but is null");
        }
        if (reason == null) {
            throw new NullPointerException("reason is marked non-null but is null");
        }
        this.category = category;
        this.reason = reason;
    }

    @NonNull
    public Category getCategory() {
        return this.category;
    }

    @NonNull
    public String getReason() {
        return this.reason;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Recognition)) {
            return false;
        }
        Recognition other = (Recognition)o;
        Category this$category = this.getCategory();
        Category other$category = other.getCategory();
        if (this$category == null ? other$category != null : !((Object)((Object)this$category)).equals((Object)other$category)) {
            return false;
        }
        String this$reason = this.getReason();
        String other$reason = other.getReason();
        return !(this$reason == null ? other$reason != null : !this$reason.equals(other$reason));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Category $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : ((Object)((Object)$category)).hashCode());
        String $reason = this.getReason();
        result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
        return result;
    }

    public String toString() {
        return "Recognition(category=" + this.getCategory() + ", reason=" + this.getReason() + ")";
    }
}

