/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.exceprecog;

import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.isis.applib.services.exceprecog.Category;
import org.apache.isis.applib.services.exceprecog.ExceptionRecognizerAbstract;
import org.apache.isis.commons.internal.exceptions._Exceptions;

public class ExceptionRecognizerForType
extends ExceptionRecognizerAbstract {
    protected static final Predicate<Throwable> ofType(Class<? extends Throwable> exceptionType) {
        return ex -> exceptionType.isAssignableFrom(ex.getClass());
    }

    protected static final Predicate<Throwable> excluding(String ... messages) {
        return ex -> {
            for (Throwable throwable : _Exceptions.getCausalChain((Throwable)ex)) {
                if (!_Exceptions.containsAnyOfTheseMessages((Throwable)throwable, (String[])messages)) continue;
                return false;
            }
            return true;
        };
    }

    protected static final Predicate<Throwable> including(String ... messages) {
        return ex -> {
            for (Throwable throwable : _Exceptions.getCausalChain((Throwable)ex)) {
                if (!_Exceptions.containsAnyOfTheseMessages((Throwable)throwable, (String[])messages)) continue;
                return true;
            }
            return false;
        };
    }

    public ExceptionRecognizerForType(Category category, Class<? extends Exception> exceptionType, Function<Throwable, String> rootCauseMessageFormatter) {
        this(category, ExceptionRecognizerForType.ofType(exceptionType), rootCauseMessageFormatter);
    }

    public ExceptionRecognizerForType(Category category, Predicate<Throwable> predicate, Function<Throwable, String> rootCauseMessageFormatter) {
        super(category, predicate, rootCauseMessageFormatter);
    }

    public ExceptionRecognizerForType(Category category, Class<? extends Exception> exceptionType) {
        this(category, exceptionType, null);
    }

    public ExceptionRecognizerForType(Class<? extends Exception> exceptionType, Function<Throwable, String> rootCauseMessageFormatter) {
        this(Category.OTHER, exceptionType, rootCauseMessageFormatter);
    }

    public ExceptionRecognizerForType(Predicate<Throwable> predicate, Function<Throwable, String> rootCauseMessageFormatter) {
        this(Category.OTHER, predicate, rootCauseMessageFormatter);
    }

    public ExceptionRecognizerForType(Class<? extends Exception> exceptionType) {
        this(Category.OTHER, exceptionType);
    }
}

