/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.exceprecog;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.inject.Inject;
import org.apache.isis.applib.exceptions.TranslatableException;
import org.apache.isis.applib.services.exceprecog.Category;
import org.apache.isis.applib.services.exceprecog.ExceptionRecognizer;
import org.apache.isis.applib.services.exceprecog.Recognition;
import org.apache.isis.applib.services.i18n.TranslatableString;
import org.apache.isis.applib.services.i18n.TranslationContext;
import org.apache.isis.applib.services.i18n.TranslationService;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.exceptions._Exceptions;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ExceptionRecognizerAbstract
implements ExceptionRecognizer {
    private static final Logger log = LogManager.getLogger(ExceptionRecognizerAbstract.class);
    @Inject
    protected TranslationService translationService;
    private boolean disabled = false;
    private final Category category;
    private final Predicate<Throwable> predicate;
    private final Function<Throwable, String> rootCauseMessageFormatter;
    protected boolean logRecognizedExceptions;

    protected static Function<String, String> constant(String message) {
        return input -> message;
    }

    protected static Function<Throwable, String> prefix(String prefix) {
        return rootCause -> prefix + ": " + rootCause.getMessage();
    }

    public ExceptionRecognizerAbstract(Category category, Predicate<Throwable> predicate, Function<Throwable, String> rootCauseMessageFormatter) {
        Objects.requireNonNull(predicate);
        this.category = category;
        this.predicate = predicate;
        this.rootCauseMessageFormatter = rootCauseMessageFormatter != null ? rootCauseMessageFormatter : Throwable::getMessage;
    }

    public ExceptionRecognizerAbstract(Predicate<Throwable> predicate, Function<Throwable, String> rootCauseMessageFormatter) {
        this(Category.OTHER, predicate, rootCauseMessageFormatter);
    }

    public ExceptionRecognizerAbstract(Category category, Predicate<Throwable> predicate) {
        this(category, predicate, null);
    }

    public ExceptionRecognizerAbstract(Predicate<Throwable> predicate) {
        this(Category.OTHER, predicate);
    }

    private Optional<String> recognizeRootCause(Throwable ex) {
        return _Exceptions.streamCausalChain((Throwable)ex).filter(this.predicate).map(throwable -> {
            if (this.logRecognizedExceptions) {
                log.info("Recognized exception, stacktrace : ", throwable);
            }
            if (ex instanceof TranslatableException) {
                TranslatableException translatableException = (TranslatableException)((Object)ex);
                TranslatableString translatableMessage = translatableException.getTranslatableMessage();
                TranslationContext translationContext = translatableException.getTranslationContext();
                if (translatableMessage != null && translationContext != null) {
                    return translatableMessage.translate(this.translationService, translationContext);
                }
            }
            String formattedMessage = _Exceptions.getRootCause((Throwable)throwable).map(this.rootCauseMessageFormatter::apply).orElse("");
            return formattedMessage;
        }).filter(_NullSafe::isPresent).findFirst();
    }

    @Override
    public Optional<Recognition> recognize(Throwable ex) {
        if (this.disabled) {
            return Optional.empty();
        }
        return Recognition.of(this.category, this.recognizeRootCause(ex).orElse(null));
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }
}

