/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.error;

import java.util.function.UnaryOperator;
import org.apache.isis.applib.services.error.Ticket;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.base._Strings;

public class SimpleTicket
implements Ticket {
    private static final long serialVersionUID = 4900947111894407314L;
    private final String reference;
    private final String userMessage;
    private final String details;
    private final Ticket.StackTracePolicy stackTracePolicy;
    private final String kittenUrl;

    public SimpleTicket(String reference, String userMessage, String details) {
        this(reference, userMessage, details, Ticket.StackTracePolicy.HIDE);
    }

    public SimpleTicket(String reference, String userMessage, String details, Ticket.StackTracePolicy stackTracePolicy) {
        this(reference, userMessage, details, stackTracePolicy, null);
    }

    public SimpleTicket(String reference, String userMessage, String details, String kittenUrl) {
        this(reference, userMessage, details, Ticket.StackTracePolicy.HIDE, kittenUrl);
    }

    public SimpleTicket(String reference, String userMessage, String details, Ticket.StackTracePolicy stackTracePolicy, String kittenUrl) {
        this.reference = reference;
        this.userMessage = userMessage;
        this.details = details;
        this.stackTracePolicy = stackTracePolicy;
        this.kittenUrl = kittenUrl;
    }

    @Override
    public String getReference() {
        return this.reference;
    }

    @Override
    public String getUserMessage() {
        return this.userMessage;
    }

    @Override
    public String getDetails() {
        return this.details;
    }

    @Override
    public Ticket.StackTracePolicy getStackTracePolicy() {
        return this.stackTracePolicy;
    }

    public String getKittenUrl() {
        return this.kittenUrl;
    }

    @Override
    public String getMarkup() {
        return "<p>" + SimpleTicket.ifPresentMap(this.getDetails(), s -> "<h3>" + SimpleTicket.htmlEscape(s) + "</h3>") + SimpleTicket.ifPresentMap(this.getKittenUrl(), s -> "<img src=\"" + s + "\"></img>") + "</p>" + SimpleTicket.ifPresentMap(this.getReference(), s -> "<p><h4>Please quote reference: <span>" + SimpleTicket.htmlEscape(s) + "</span></h4></p>");
    }

    protected static String ifPresentMap(String x, UnaryOperator<String> operator) {
        return _NullSafe.isEmpty((String)x) ? "" : (String)operator.apply(x);
    }

    protected static String htmlEscape(String source) {
        return _Strings.htmlEscape((String)source);
    }
}

