/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.commanddto.conmap;

import java.util.List;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.core.MediaType;
import org.apache.isis.applib.services.commanddto.HasCommandDto;
import org.apache.isis.applib.services.commanddto.processor.CommandDtoProcessor;
import org.apache.isis.applib.services.commanddto.processor.spi.CommandDtoProcessorService;
import org.apache.isis.applib.services.conmap.ContentMappingService;
import org.apache.isis.applib.services.metamodel.MetaModelService;
import org.apache.isis.schema.cmd.v2.CommandDto;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Service;

@Service
@Named(value="isis.applib.ContentMappingServiceForCommandDto")
@Priority(value=0x1FFFFFFF)
@Qualifier(value="CommandDto")
public class ContentMappingServiceForCommandDto
implements ContentMappingService {
    static final String LOGICAL_TYPE_NAME = "isis.applib.ContentMappingServiceForCommandDto";
    @Inject
    MetaModelService metaModelService;
    @Inject
    List<CommandDtoProcessorService> commandDtoProcessorServices;

    @Override
    @Nullable
    public Object map(Object object, List<MediaType> acceptableMediaTypes) {
        boolean supported = this.isSupported(CommandDto.class, acceptableMediaTypes);
        if (!supported) {
            return null;
        }
        return this.asProcessedDto(object);
    }

    @Nullable
    CommandDto asProcessedDto(Object object) {
        CommandDto commandDto = this.asCommandDto(object);
        return this.asProcessedDto(object, commandDto);
    }

    @Nullable
    private CommandDto asCommandDto(Object object) {
        if (object instanceof CommandDto) {
            return (CommandDto)object;
        }
        if (object instanceof HasCommandDto) {
            return ((HasCommandDto)object).getCommandDto();
        }
        return null;
    }

    @Nullable
    private CommandDto asProcessedDto(Object domainObject, @Nullable CommandDto commandDto) {
        if (commandDto == null) {
            return null;
        }
        for (CommandDtoProcessorService commandDtoProcessorService : this.commandDtoProcessorServices) {
            commandDto = commandDtoProcessorService.process(domainObject, commandDto);
            if (commandDto != null) continue;
            return null;
        }
        String logicalMemberId = commandDto.getMember().getLogicalMemberIdentifier();
        CommandDtoProcessor commandDtoProcessor = this.metaModelService.commandDtoProcessorFor(logicalMemberId);
        if (commandDtoProcessor == null) {
            return commandDto;
        }
        return commandDtoProcessor.process(commandDto);
    }
}

