/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.command;

import java.sql.Timestamp;
import java.time.Instant;
import java.util.function.BiFunction;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.isis.applib.clock.VirtualClock;
import org.apache.isis.applib.jaxb.JavaSqlXMLGregorianCalendarMarshalling;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.services.command.Command;
import org.apache.isis.applib.services.command.CommandOutcomeHandler;
import org.apache.isis.applib.services.iactnlayer.InteractionContext;
import org.apache.isis.applib.services.user.UserMemento;
import org.apache.isis.schema.cmd.v2.CommandDto;

public interface CommandExecutorService {
    public Bookmark executeCommand(InteractionContextPolicy var1, Command var2);

    public Bookmark executeCommand(InteractionContextPolicy var1, CommandDto var2, CommandOutcomeHandler var3);

    public Bookmark executeCommand(Command var1);

    public Bookmark executeCommand(CommandDto var1, CommandOutcomeHandler var2);

    public static enum InteractionContextPolicy {
        NO_SWITCH((interactionContext, commandDto) -> interactionContext),
        SWITCH_USER_ONLY((interactionContext, commandDto) -> interactionContext.withUser(UserMemento.ofName(commandDto.getUsername()))),
        SWITCH_USER_AND_TIME((interactionContext, commandDto) -> interactionContext.withUser(UserMemento.ofName(commandDto.getUsername())).withClock(VirtualClock.nowAt(InteractionContextPolicy.timestampOf(commandDto))));

        public final BiFunction<InteractionContext, CommandDto, InteractionContext> mapper;

        private static Instant timestampOf(CommandDto commandDto) {
            XMLGregorianCalendar timestampGc = commandDto.getTimestamp();
            Timestamp javaSqlTimestamp = JavaSqlXMLGregorianCalendarMarshalling.toTimestamp(timestampGc);
            return javaSqlTimestamp.toInstant();
        }

        private InteractionContextPolicy(BiFunction<InteractionContext, CommandDto, InteractionContext> mapper) {
            this.mapper = mapper;
        }
    }
}

