/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.command;

import java.sql.Timestamp;
import java.util.UUID;
import lombok.NonNull;
import org.apache.isis.applib.jaxb.JavaSqlXMLGregorianCalendarMarshalling;
import org.apache.isis.applib.mixins.security.HasUsername;
import org.apache.isis.applib.mixins.system.HasInteractionId;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.services.command.CommandOutcomeHandler;
import org.apache.isis.applib.services.commanddto.HasCommandDto;
import org.apache.isis.commons.functional.Try;
import org.apache.isis.schema.cmd.v2.CommandDto;
import org.apache.isis.schema.common.v2.OidDto;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Command
implements HasInteractionId,
HasUsername,
HasCommandDto {
    private static final Logger log = LogManager.getLogger(Command.class);
    private final UUID interactionId;
    private CommandDto commandDto;
    private UUID parentInteractionId;
    private Timestamp startedAt;
    private Timestamp completedAt;
    private Bookmark result;
    private Throwable exception;
    private boolean systemStateChanged;
    private CommandPublishingPhase publishingPhase = CommandPublishingPhase.ONHOLD;
    private final Updater UPDATER = new Updater();

    @Override
    public String getUsername() {
        return this.commandDto != null ? this.commandDto.getUsername() : null;
    }

    public Timestamp getTimestamp() {
        return this.commandDto != null ? JavaSqlXMLGregorianCalendarMarshalling.toTimestamp(this.commandDto.getTimestamp()) : null;
    }

    public Bookmark getTarget() {
        return this.commandDto != null ? Bookmark.forOidDto((OidDto)this.commandDto.getTargets().getOid().get(0)) : null;
    }

    public String getLogicalMemberIdentifier() {
        return this.commandDto != null ? this.commandDto.getMember().getLogicalMemberIdentifier() : null;
    }

    public Updater updater() {
        return this.UPDATER;
    }

    public Command(UUID interactionId) {
        this.interactionId = interactionId;
    }

    public String toString() {
        return "Command(interactionId=" + this.getInteractionId() + ", target=" + this.getTarget() + ", memberId=" + this.getLogicalMemberIdentifier() + ", startedAt=" + this.getStartedAt() + ", completedAt=" + this.getCompletedAt() + ", result=" + this.getResult() + ", exception=" + this.getException() + ", systemStateChanged=" + this.isSystemStateChanged() + ", publishingPhase=" + this.getPublishingPhase() + ")";
    }

    @Override
    public UUID getInteractionId() {
        return this.interactionId;
    }

    @Override
    public CommandDto getCommandDto() {
        return this.commandDto;
    }

    public UUID getParentInteractionId() {
        return this.parentInteractionId;
    }

    public Timestamp getStartedAt() {
        return this.startedAt;
    }

    public Timestamp getCompletedAt() {
        return this.completedAt;
    }

    public Bookmark getResult() {
        return this.result;
    }

    public Throwable getException() {
        return this.exception;
    }

    public boolean isSystemStateChanged() {
        return this.systemStateChanged;
    }

    public CommandPublishingPhase getPublishingPhase() {
        return this.publishingPhase;
    }

    public class Updater
    implements CommandOutcomeHandler {
        public void setCommandDto(CommandDto commandDto) {
            String dtoInteractionId;
            Command.this.commandDto = commandDto;
            String commandInteractionId = Command.this.getInteractionId().toString();
            if (!commandInteractionId.equals(dtoInteractionId = commandDto.getInteractionId())) {
                log.warn("setting CommandDto on a Command has side-effects if their InteractionIds don't match; forcing CommandDto's Id to be same as Command's");
                commandDto.setInteractionId(commandInteractionId);
            }
        }

        public void setParentInteractionId(UUID parentInteractionId) {
            Command.this.parentInteractionId = parentInteractionId;
        }

        @Override
        public Timestamp getStartedAt() {
            return Command.this.getStartedAt();
        }

        @Override
        public void setStartedAt(Timestamp startedAt) {
            Command.this.startedAt = startedAt;
        }

        @Override
        public void setCompletedAt(Timestamp completed) {
            Command.this.completedAt = completed;
        }

        @Override
        public void setResult(Try<Bookmark> resultBookmark) {
            Command.this.result = resultBookmark.getValue().orElse(null);
            Command.this.exception = resultBookmark.getFailure().orElse(null);
        }

        public void setSystemStateChanged(boolean systemStateChanged) {
            Command.this.systemStateChanged = systemStateChanged;
        }

        public void setPublishingPhase(@NonNull CommandPublishingPhase publishingPhase) {
            if (publishingPhase == null) {
                throw new NullPointerException("publishingPhase is marked non-null but is null");
            }
            if (Command.this.publishingPhase.isCompleted()) {
                return;
            }
            Command.this.publishingPhase = publishingPhase;
        }
    }

    public static enum CommandPublishingPhase {
        ONHOLD,
        READY,
        COMPLETED;


        public boolean isOnhold() {
            return this == ONHOLD;
        }

        public boolean isReady() {
            return this == READY;
        }

        public boolean isCompleted() {
            return this == COMPLETED;
        }
    }
}

