/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.clock;

import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.apache.isis.applib.clock.VirtualClock;
import org.apache.isis.applib.services.iactnlayer.InteractionContext;
import org.apache.isis.applib.services.iactnlayer.InteractionLayerTracker;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@Named(value="isis.applib.ClockService")
@Priority(value=0x3FFFFFFF)
@Qualifier(value="Default")
public class ClockService {
    static final String LOGICAL_TYPE_NAME = "isis.applib.ClockService";
    private final Provider<InteractionLayerTracker> interactionLayerTrackerProvider;

    public VirtualClock getClock() {
        return ((InteractionLayerTracker)this.interactionLayerTrackerProvider.get()).currentInteractionContext().map(InteractionContext::getClock).orElseGet(VirtualClock::system);
    }

    public long getEpochMillis() {
        return this.getClock().nowAsEpochMilli();
    }

    @Inject
    public ClockService(Provider<InteractionLayerTracker> interactionLayerTrackerProvider) {
        this.interactionLayerTrackerProvider = interactionLayerTrackerProvider;
    }
}

