/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.bookmark.idstringifiers;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.isis.applib.graph.tree.TreeState;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.commons.internal.collections._Sets;

public final class PredefinedSerializables {
    private static final Set<Class<? extends Serializable>> serializableFinalTypes = _Sets.of((Object[])new Class[]{String.class, String[].class, Class.class, Class[].class, Character.class, Character[].class, char[].class, Boolean.class, Boolean[].class, boolean[].class, Byte[].class, byte[].class, Short[].class, short[].class, Integer[].class, int[].class, Long[].class, long[].class, Float[].class, float[].class, Double[].class, double[].class});
    private static final List<Class<? extends Serializable>> serializableTypes = List.of(Date.class, java.sql.Date.class, Enum.class, Bookmark.class, TreeState.class);

    public static boolean isPredefinedSerializable(Class<?> cls) {
        if (!Serializable.class.isAssignableFrom(cls)) {
            return false;
        }
        if (cls.isPrimitive() || Number.class.isAssignableFrom(cls)) {
            return true;
        }
        if (cls.getName().startsWith("java.time.")) {
            return true;
        }
        if (cls.getName().startsWith("org.joda.time.")) {
            return true;
        }
        if (serializableFinalTypes.contains(cls)) {
            return true;
        }
        return serializableTypes.stream().anyMatch(t -> t.isAssignableFrom(cls));
    }

    private PredefinedSerializables() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

