/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.bookmark;

import lombok.NonNull;
import org.apache.isis.commons.internal.assertions._Assert;

public interface IdStringifier<T> {
    public static final char SEPARATOR = '_';

    public Class<T> getCorrespondingClass();

    public String enstring(@NonNull T var1);

    public T destring(@NonNull Class<?> var1, @NonNull String var2);

    default public boolean isValid(@NonNull T value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        try {
            return this.enstring(value) != null;
        }
        catch (Throwable e) {
            return false;
        }
    }

    @Deprecated
    public static abstract class AbstractWithPrefix<T>
    implements IdStringifier<T> {
        private final Class<T> correspondingClass;
        private final String prefix;

        public AbstractWithPrefix(@NonNull Class<T> correspondingClass, @NonNull String typeCode) {
            if (correspondingClass == null) {
                throw new NullPointerException("correspondingClass is marked non-null but is null");
            }
            if (typeCode == null) {
                throw new NullPointerException("typeCode is marked non-null but is null");
            }
            _Assert.assertFalse((boolean)correspondingClass.isPrimitive(), () -> String.format("not allowed to be initialzed with a primitive class (%s), use the boxed variant instead", correspondingClass));
            this.correspondingClass = correspondingClass;
            this.prefix = typeCode + "_";
        }

        @Override
        public final String enstring(@NonNull T value) {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            return this.prefix + this.doEnstring(value);
        }

        protected String doEnstring(T value) {
            return value.toString();
        }

        @Override
        public final T destring(@NonNull Class<?> targetEntityClass, @NonNull String stringified) {
            if (targetEntityClass == null) {
                throw new NullPointerException("targetEntityClass is marked non-null but is null");
            }
            if (stringified == null) {
                throw new NullPointerException("stringified is marked non-null but is null");
            }
            String suffix = this.removePrefix(stringified);
            return this.doDestring(suffix, targetEntityClass);
        }

        protected abstract T doDestring(@NonNull String var1, @NonNull Class<?> var2);

        private String removePrefix(String str) {
            if (str.startsWith(this.prefix)) {
                return str.substring(this.prefix.length());
            }
            throw new IllegalArgumentException(String.format("expected id to start with '%s', but got '%s'", this.prefix, str));
        }

        public boolean recognizes(String stringified) {
            return stringified.startsWith(this.prefix);
        }

        @Override
        public Class<T> getCorrespondingClass() {
            return this.correspondingClass;
        }
    }

    public static interface EntityAgnostic<T>
    extends IdStringifier<T> {
        public T destring(@NonNull String var1);

        @Override
        default public T destring(@NonNull Class<?> targetEntityClass, @NonNull String stringified) {
            if (targetEntityClass == null) {
                throw new NullPointerException("targetEntityClass is marked non-null but is null");
            }
            if (stringified == null) {
                throw new NullPointerException("stringified is marked non-null but is null");
            }
            return this.destring(stringified);
        }
    }
}

