/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.bookmark;

import java.util.Objects;
import java.util.Optional;
import java.util.StringTokenizer;
import javax.inject.Named;
import lombok.NonNull;
import org.apache.isis.applib.annotation.Value;
import org.apache.isis.applib.id.LogicalType;
import org.apache.isis.applib.services.bookmark.Oid;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.commons.internal.codec._UrlDecoderUtil;
import org.apache.isis.commons.internal.exceptions._Exceptions;
import org.apache.isis.schema.common.v2.OidDto;
import org.springframework.lang.Nullable;

@Named(value="isis.applib.Bookmark")
@Value
public final class Bookmark
implements Oid {
    static final String LOGICAL_TYPE_NAME = "isis.applib.Bookmark";
    private static final long serialVersionUID = 3L;
    private final String logicalTypeName;
    private final String identifier;
    @Nullable
    private final String hintId;
    private final int hashCode;

    public static Bookmark empty(@NonNull LogicalType logicalType) {
        if (logicalType == null) {
            throw new NullPointerException("logicalType is marked non-null but is null");
        }
        return Bookmark.emptyForLogicalTypeName(logicalType.getLogicalTypeName());
    }

    public static Bookmark emptyForLogicalTypeName(@NonNull String logicalTypeName) {
        if (logicalTypeName == null) {
            throw new NullPointerException("logicalTypeName is marked non-null but is null");
        }
        return new Bookmark(logicalTypeName, null, null);
    }

    public static Bookmark forLogicalTypeNameAndIdentifier(@NonNull String logicalTypeName, @NonNull String urlSafeIdentifier) {
        if (logicalTypeName == null) {
            throw new NullPointerException("logicalTypeName is marked non-null but is null");
        }
        if (urlSafeIdentifier == null) {
            throw new NullPointerException("urlSafeIdentifier is marked non-null but is null");
        }
        return new Bookmark(logicalTypeName, urlSafeIdentifier, null);
    }

    public static Bookmark forLogicalTypeAndIdentifier(@NonNull LogicalType logicalType, @NonNull String urlSafeIdentifier) {
        if (logicalType == null) {
            throw new NullPointerException("logicalType is marked non-null but is null");
        }
        if (urlSafeIdentifier == null) {
            throw new NullPointerException("urlSafeIdentifier is marked non-null but is null");
        }
        return Bookmark.forLogicalTypeNameAndIdentifier(logicalType.getLogicalTypeName(), urlSafeIdentifier);
    }

    public static Bookmark forOidDto(@NonNull OidDto oidDto) {
        if (oidDto == null) {
            throw new NullPointerException("oidDto is marked non-null but is null");
        }
        return Bookmark.forLogicalTypeNameAndIdentifier(oidDto.getType(), oidDto.getId());
    }

    public Bookmark withHintId(@Nullable String hintId) {
        return new Bookmark(this.getLogicalTypeName(), this.getIdentifier(), hintId);
    }

    private Bookmark(String logicalTypeName, String urlSafeIdentifier, String hintId) {
        this.logicalTypeName = logicalTypeName;
        this.identifier = urlSafeIdentifier;
        this.hintId = hintId;
        this.hashCode = Objects.hash(logicalTypeName, urlSafeIdentifier);
    }

    public static Optional<Bookmark> parse(@Nullable String str) {
        if (_Strings.isNullOrEmpty((CharSequence)str)) {
            return Optional.empty();
        }
        StringTokenizer tokenizer = new StringTokenizer(str, ":");
        int tokenCount = tokenizer.countTokens();
        if (tokenCount == 1) {
            return str.endsWith(":") || str.startsWith(":") ? Optional.empty() : Optional.of(Bookmark.emptyForLogicalTypeName(tokenizer.nextToken()));
        }
        if (tokenCount == 2) {
            return Optional.of(Bookmark.forLogicalTypeNameAndIdentifier(tokenizer.nextToken(), tokenizer.nextToken()));
        }
        if (tokenCount > 2) {
            return Optional.of(Bookmark.forLogicalTypeNameAndIdentifier(tokenizer.nextToken(), tokenizer.nextToken("").substring(1)));
        }
        return Optional.empty();
    }

    public static Bookmark parseElseFail(@Nullable String input) {
        return Bookmark.parse(input).orElseThrow(() -> _Exceptions.illegalArgument((String)"cannot parse Bookmark %s", (Object[])new Object[]{input}));
    }

    public static Optional<Bookmark> parseUrlEncoded(@Nullable String urlEncodedStr) {
        return _Strings.isEmpty((CharSequence)urlEncodedStr) ? Optional.empty() : Bookmark.parse(_UrlDecoderUtil.urlDecode((String)urlEncodedStr));
    }

    public OidDto toOidDto() {
        OidDto oidDto = new OidDto();
        oidDto.setType(this.getLogicalTypeName());
        oidDto.setId(this.getIdentifier());
        return oidDto;
    }

    @Override
    public String stringify() {
        return this.stringify(this.identifier);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        return this.equals((Bookmark)other);
    }

    public boolean equals(Bookmark other) {
        return Objects.equals(this.logicalTypeName, other.getLogicalTypeName()) && Objects.equals(this.identifier, other.getIdentifier());
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.stringify();
    }

    public String stringifyHonoringHintIfAny() {
        return _Strings.isNotEmpty((CharSequence)this.hintId) ? this.stringify(this.hintId) : this.stringify(this.identifier);
    }

    public boolean isEmpty() {
        return this.identifier == null;
    }

    private String stringify(String id) {
        return !this.isEmpty() ? this.logicalTypeName + ":" + id : this.logicalTypeName;
    }

    private Bookmark(String logicalTypeName, String identifier, @Nullable String hintId, int hashCode) {
        this.logicalTypeName = logicalTypeName;
        this.identifier = identifier;
        this.hintId = hintId;
        this.hashCode = hashCode;
    }

    @Override
    public String getLogicalTypeName() {
        return this.logicalTypeName;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Nullable
    public String getHintId() {
        return this.hintId;
    }
}

