/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.appfeatui;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.OptionalInt;
import javax.inject.Named;
import org.apache.isis.applib.annotation.DomainObject;
import org.apache.isis.applib.annotation.DomainObjectLayout;
import org.apache.isis.applib.annotation.MemberSupport;
import org.apache.isis.applib.annotation.Optionality;
import org.apache.isis.applib.annotation.Property;
import org.apache.isis.applib.annotation.PropertyLayout;
import org.apache.isis.applib.services.appfeat.ApplicationFeatureId;
import org.apache.isis.applib.services.appfeatui.ApplicationFeatureViewModel;
import org.apache.isis.applib.services.appfeatui.ApplicationTypeMember;

@Named(value="isis.feat.ApplicationTypeProperty")
@DomainObject
@DomainObjectLayout(paged=100)
public class ApplicationTypeProperty
extends ApplicationTypeMember {
    static final String LOGICAL_TYPE_NAME = "isis.feat.ApplicationTypeProperty";

    public ApplicationTypeProperty() {
    }

    public ApplicationTypeProperty(ApplicationFeatureId featureId) {
        super(featureId);
    }

    public ApplicationTypeProperty(String memento) {
        super(memento);
    }

    @PropertyLayout(fieldSetId="dataType", sequence="2.6")
    @ReturnType
    public String getReturnType() {
        return this.getFeature().getActionReturnType().map(Class::getSimpleName).orElse("<none>");
    }

    @Derived
    public boolean isDerived() {
        return this.getFeature().isPropertyOrCollectionDerived();
    }

    @MaxLength
    public Integer getMaxLength() {
        OptionalInt maxLen = this.getFeature().getPropertyMaxLength();
        return maxLen.isPresent() ? Integer.valueOf(maxLen.getAsInt()) : null;
    }

    @MemberSupport
    public boolean hideMaxLength() {
        if (!this.getFeature().getPropertyMaxLength().isPresent()) {
            return true;
        }
        return !String.class.getSimpleName().equals(this.getReturnType());
    }

    @TypicalLength
    public Integer getTypicalLength() {
        OptionalInt maxLen = this.getFeature().getPropertyTypicalLength();
        return maxLen.isPresent() ? Integer.valueOf(maxLen.getAsInt()) : null;
    }

    @MemberSupport
    public boolean hideTypicalLength() {
        if (!this.getFeature().getPropertyTypicalLength().isPresent()) {
            return true;
        }
        return !String.class.getSimpleName().equals(this.getReturnType());
    }

    @Property(domainEvent=DomainEvent.class, optionality=Optionality.OPTIONAL)
    @PropertyLayout(fieldSetId="detail", sequence="2.9")
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface TypicalLength {

        public static class DomainEvent
        extends PropertyDomainEvent<Integer> {
        }
    }

    @Property(domainEvent=DomainEvent.class, optionality=Optionality.OPTIONAL)
    @PropertyLayout(fieldSetId="detail", sequence="2.8")
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface MaxLength {

        public static class DomainEvent
        extends PropertyDomainEvent<Integer> {
        }
    }

    @Property(domainEvent=DomainEvent.class)
    @PropertyLayout(fieldSetId="detail", sequence="2.7")
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Derived {

        public static class DomainEvent
        extends PropertyDomainEvent<Boolean> {
        }
    }

    @ApplicationFeatureViewModel.TypeSimpleName
    @Property(domainEvent=DomainEvent.class)
    @PropertyLayout(fieldSetId="dataType", sequence="2.6")
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ReturnType {

        public static class DomainEvent
        extends PropertyDomainEvent<String> {
        }
    }

    public static abstract class PropertyDomainEvent<T>
    extends ApplicationTypeMember.PropertyDomainEvent<ApplicationTypeProperty, T> {
    }
}

