/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.appfeatui;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import javax.inject.Named;
import org.apache.isis.applib.annotation.DomainObject;
import org.apache.isis.applib.annotation.DomainObjectLayout;
import org.apache.isis.applib.annotation.Property;
import org.apache.isis.applib.annotation.PropertyLayout;
import org.apache.isis.applib.annotation.SemanticsOf;
import org.apache.isis.applib.services.appfeat.ApplicationFeatureId;
import org.apache.isis.applib.services.appfeatui.ApplicationFeatureViewModel;
import org.apache.isis.applib.services.appfeatui.ApplicationTypeMember;

@Named(value="isis.feat.ApplicationTypeAction")
@DomainObject
@DomainObjectLayout(paged=100)
public class ApplicationTypeAction
extends ApplicationTypeMember {
    static final String LOGICAL_TYPE_NAME = "isis.feat.ApplicationTypeAction";

    public ApplicationTypeAction() {
    }

    public ApplicationTypeAction(ApplicationFeatureId featureId) {
        super(featureId);
    }

    public ApplicationTypeAction(String memento) {
        super(memento);
    }

    @PropertyLayout(fieldSetId="dataType", sequence="2.6")
    @ReturnType
    public String getReturnType() {
        return this.getFeature().getActionReturnType().map(Class::getSimpleName).orElse("<none>");
    }

    @ActionSemantics
    public SemanticsOf getActionSemantics() {
        return this.getFeature().getActionSemantics().orElse(null);
    }

    @Property(domainEvent=DomainEvent.class)
    @PropertyLayout(fieldSetId="detail", sequence="2.8")
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ActionSemantics {

        public static class DomainEvent
        extends PropertyDomainEvent<SemanticsOf> {
        }
    }

    @ApplicationFeatureViewModel.TypeSimpleName
    @Property(domainEvent=DomainEvent.class)
    @PropertyLayout(fieldSetId="dataType", sequence="2.6")
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ReturnType {

        public static class DomainEvent
        extends PropertyDomainEvent<String> {
        }
    }

    public static abstract class PropertyDomainEvent<T>
    extends ApplicationTypeMember.PropertyDomainEvent<ApplicationTypeAction, T> {
    }
}

