/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.appfeatui;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Named;
import lombok.NonNull;
import org.apache.isis.applib.IsisModuleApplib;
import org.apache.isis.applib.ViewModel;
import org.apache.isis.applib.annotation.DomainObject;
import org.apache.isis.applib.annotation.MemberSupport;
import org.apache.isis.applib.annotation.Navigable;
import org.apache.isis.applib.annotation.ObjectSupport;
import org.apache.isis.applib.annotation.Parameter;
import org.apache.isis.applib.annotation.ParameterLayout;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.annotation.Property;
import org.apache.isis.applib.annotation.PropertyLayout;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.services.appfeat.ApplicationFeature;
import org.apache.isis.applib.services.appfeat.ApplicationFeatureId;
import org.apache.isis.applib.services.appfeat.ApplicationFeatureRepository;
import org.apache.isis.applib.services.appfeat.ApplicationFeatureSort;
import org.apache.isis.applib.services.appfeat.ApplicationMemberSort;
import org.apache.isis.applib.services.appfeatui.ApplicationNamespace;
import org.apache.isis.applib.services.appfeatui.ApplicationType;
import org.apache.isis.applib.services.appfeatui.ApplicationTypeAction;
import org.apache.isis.applib.services.appfeatui.ApplicationTypeCollection;
import org.apache.isis.applib.services.appfeatui.ApplicationTypeProperty;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.services.factory.FactoryService;
import org.apache.isis.applib.util.Equality;
import org.apache.isis.applib.util.Hashing;
import org.apache.isis.applib.util.ObjectContracts;
import org.apache.isis.applib.util.ToString;
import org.apache.isis.commons.internal.assertions._Assert;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.commons.internal.collections._Lists;

@Named(value="isis.feat.ApplicationFeatureViewModel")
@DomainObject
public abstract class ApplicationFeatureViewModel
implements ViewModel {
    static final String LOGICAL_TYPE_NAME = "isis.feat.ApplicationFeatureViewModel";
    @Inject
    private FactoryService factory;
    @Inject
    private ApplicationFeatureRepository featureRepository;
    private ApplicationFeatureId featureId;
    private static final Equality<ApplicationFeatureViewModel> equality = ObjectContracts.checkEquals(ApplicationFeatureViewModel::getFeatureId);
    private static final Hashing<ApplicationFeatureViewModel> hashing = ObjectContracts.hashing(ApplicationFeatureViewModel::getFeatureId);
    private static final ToString<ApplicationFeatureViewModel> toString = ObjectContracts.toString("featureId", ApplicationFeatureViewModel::getFeatureId);

    public static ApplicationFeatureViewModel newViewModel(ApplicationFeatureId featureId, ApplicationFeatureRepository applicationFeatureRepository, FactoryService factoryService) {
        Class<? extends ApplicationFeatureViewModel> vmClass = ApplicationFeatureViewModel.viewModelClassFor(featureId, applicationFeatureRepository);
        if (featureId.getSort().isNamespace()) {
            _Assert.assertEquals(vmClass, ApplicationNamespace.class);
            return factoryService.viewModel(new ApplicationNamespace(featureId));
        }
        return factoryService.viewModel(vmClass, Bookmark.forLogicalTypeNameAndIdentifier(featureId.getLogicalTypeName(), featureId.asEncodedString()));
    }

    private static Class<? extends ApplicationFeatureViewModel> viewModelClassFor(ApplicationFeatureId featureId, ApplicationFeatureRepository applicationFeatureRepository) {
        switch (featureId.getSort()) {
            case NAMESPACE: {
                return ApplicationNamespace.class;
            }
            case TYPE: {
                return ApplicationType.class;
            }
            case MEMBER: {
                ApplicationMemberSort memberSort = Optional.ofNullable(applicationFeatureRepository.findFeature(featureId)).flatMap(ApplicationFeature::getMemberSort).orElse(null);
                if (memberSort == null) break;
                switch (memberSort) {
                    case PROPERTY: {
                        return ApplicationTypeProperty.class;
                    }
                    case COLLECTION: {
                        return ApplicationTypeCollection.class;
                    }
                    case ACTION: {
                        return ApplicationTypeAction.class;
                    }
                }
            }
        }
        throw new IllegalArgumentException("could not determine feature type; featureId = " + featureId);
    }

    public ApplicationFeatureViewModel() {
        this(ApplicationFeatureId.NAMESPACE_DEFAULT);
    }

    ApplicationFeatureViewModel(ApplicationFeatureId featureId) {
        this.setFeatureId(featureId);
    }

    @ObjectSupport
    public String title() {
        return this.getFullyQualifiedName();
    }

    @ObjectSupport
    public String iconName() {
        return "applicationFeature";
    }

    public ApplicationFeatureViewModel(String encodedMemento) {
        this(ApplicationFeatureId.parseEncoded(encodedMemento));
    }

    @Override
    public String viewModelMemento() {
        return this.getFeatureId().asEncodedString();
    }

    @Programmatic
    ApplicationFeature getFeature() {
        return this.featureRepository.findFeature(this.getFeatureId());
    }

    @Programmatic
    public String getFullyQualifiedName() {
        return this.getFeatureId().getFullyQualifiedName();
    }

    @Programmatic
    public ApplicationFeatureSort getSort() {
        return this.getFeatureId().getSort();
    }

    @NamespaceName
    public String getNamespaceName() {
        return this.getFeatureId().getNamespace();
    }

    @TypeSimpleName
    public String getTypeSimpleName() {
        return this.getFeatureId().getTypeSimpleName();
    }

    @MemberSupport
    public boolean hideTypeSimpleName() {
        return this.getSort().isNamespace();
    }

    @MemberName
    public String getMemberName() {
        return this.getFeatureId().getLogicalMemberName();
    }

    @MemberSupport
    public boolean hideMemberName() {
        return !this.getSort().isMember();
    }

    @Parent
    public ApplicationFeatureViewModel getParent() {
        ApplicationFeatureId parentId;
        ApplicationFeatureId applicationFeatureId = parentId = this.getSort() == ApplicationFeatureSort.MEMBER ? this.getFeatureId().getParentTypeFeatureId() : this.getFeatureId().getParentNamespaceFeatureId();
        if (parentId == null) {
            return null;
        }
        ApplicationFeature feature = this.featureRepository.findFeature(parentId);
        if (feature == null) {
            return null;
        }
        Class<? extends ApplicationFeatureViewModel> cls = ApplicationFeatureViewModel.viewModelClassFor(parentId, this.featureRepository);
        return this.factory.viewModel(cls, Bookmark.forLogicalTypeNameAndIdentifier(parentId.getLogicalTypeName(), parentId.asEncodedString()));
    }

    @Programmatic
    public ApplicationFeatureViewModel getParentNamespace() {
        return ApplicationFeatureViewModel.newViewModel(this.getFeatureId().getParentNamespaceFeatureId(), this.featureRepository, this.factory);
    }

    public boolean equals(Object obj) {
        return equality.equals(this, obj);
    }

    public int hashCode() {
        return hashing.hashCode(this);
    }

    public String toString() {
        return toString.toString(this);
    }

    public static <T extends ApplicationFeatureViewModel> Function<ApplicationFeatureId, T> factory(@NonNull ApplicationFeatureRepository featureRepository, @NonNull FactoryService factory, @NonNull Class<T> viewModelType) {
        if (featureRepository == null) {
            throw new NullPointerException("featureRepository is marked non-null but is null");
        }
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        if (viewModelType == null) {
            throw new NullPointerException("viewModelType is marked non-null but is null");
        }
        return featureId -> (ApplicationFeatureViewModel)_Casts.uncheckedCast((Object)ApplicationFeatureViewModel.newViewModel(featureId, featureRepository, factory));
    }

    protected <T extends ApplicationFeatureViewModel> List<T> asViewModels(Collection<ApplicationFeatureId> featureIds, Class<T> viewModelType) {
        return (List)featureIds.stream().map(ApplicationFeatureViewModel.factory(this.featureRepository, this.factory, viewModelType)).collect(_Lists.toUnmodifiable());
    }

    protected <T extends ApplicationFeatureViewModel> T asViewModel(ApplicationFeatureId featureId, Class<T> viewModelType) {
        return (T)((ApplicationFeatureViewModel)ApplicationFeatureViewModel.factory(this.featureRepository, this.factory, viewModelType).apply(featureId));
    }

    @Programmatic
    public ApplicationFeatureId getFeatureId() {
        return this.featureId;
    }

    public void setFeatureId(ApplicationFeatureId featureId) {
        this.featureId = featureId;
    }

    @Property(domainEvent=DomainEvent.class)
    @PropertyLayout(fieldSetId="parent", hidden=Where.ALL_TABLES, navigable=Navigable.PARENT, sequence="2.6")
    @ParameterLayout(named="Parent")
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Parent {

        public static class DomainEvent
        extends PropertyDomainEvent<ApplicationFeatureViewModel, ApplicationFeatureViewModel> {
        }
    }

    @Property(domainEvent=DomainEvent.class, maxLength=50)
    @PropertyLayout(fieldSetId="identity", sequence="2.4", typicalLength=50)
    @Parameter(maxLength=50)
    @ParameterLayout(named="Member Name", typicalLength=50)
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface MemberName {
        public static final int MAX_LENGTH = 50;
        public static final int TYPICAL_LENGTH = 50;

        public static class DomainEvent
        extends PropertyDomainEvent<ApplicationFeatureViewModel, String> {
        }
    }

    @Property(domainEvent=DomainEvent.class, maxLength=50)
    @PropertyLayout(typicalLength=50, fieldSetId="identity", sequence="2.3")
    @Parameter(maxLength=50)
    @ParameterLayout(named="Type Simple Name", typicalLength=50)
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface TypeSimpleName {
        public static final int MAX_LENGTH = 50;
        public static final int TYPICAL_LENGTH = 50;

        public static class DomainEvent
        extends PropertyDomainEvent<ApplicationFeatureViewModel, String> {
        }
    }

    @Property(domainEvent=DomainEvent.class, maxLength=50)
    @PropertyLayout(fieldSetId="identity", sequence="2.2", typicalLength=50)
    @Parameter(maxLength=50)
    @ParameterLayout(named="Namespace Name", typicalLength=50)
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface NamespaceName {
        public static final int MAX_LENGTH = 50;
        public static final int TYPICAL_LENGTH = 50;

        public static class DomainEvent
        extends PropertyDomainEvent<ApplicationFeatureViewModel, String> {
        }
    }

    public static abstract class ActionDomainEvent<S extends ApplicationFeatureViewModel>
    extends IsisModuleApplib.ActionDomainEvent<S> {
    }

    public static abstract class CollectionDomainEvent<S extends ApplicationFeatureViewModel, T>
    extends IsisModuleApplib.CollectionDomainEvent<S, T> {
    }

    public static abstract class PropertyDomainEvent<S extends ApplicationFeatureViewModel, T>
    extends IsisModuleApplib.PropertyDomainEvent<S, T> {
    }
}

