/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.appfeatui;

import java.util.Collection;
import java.util.List;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.isis.applib.IsisModuleApplib;
import org.apache.isis.applib.annotation.Action;
import org.apache.isis.applib.annotation.ActionLayout;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.DomainServiceLayout;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.ObjectSupport;
import org.apache.isis.applib.annotation.RestrictTo;
import org.apache.isis.applib.annotation.SemanticsOf;
import org.apache.isis.applib.services.appfeat.ApplicationFeature;
import org.apache.isis.applib.services.appfeat.ApplicationFeatureRepository;
import org.apache.isis.applib.services.appfeatui.ApplicationFeatureViewModel;
import org.apache.isis.applib.services.appfeatui.ApplicationNamespace;
import org.apache.isis.applib.services.appfeatui.ApplicationType;
import org.apache.isis.applib.services.appfeatui.ApplicationTypeAction;
import org.apache.isis.applib.services.appfeatui.ApplicationTypeCollection;
import org.apache.isis.applib.services.appfeatui.ApplicationTypeProperty;
import org.apache.isis.applib.services.factory.FactoryService;
import org.apache.isis.applib.services.repository.RepositoryService;
import org.apache.isis.commons.internal.collections._Lists;

@DomainService(nature=NatureOfService.VIEW)
@DomainServiceLayout(named="Prototyping", menuBar=DomainServiceLayout.MenuBar.SECONDARY)
@Named(value="isis.feat.ApplicationFeatureMenu")
@Priority(value=0x1FFFFFFF)
public class ApplicationFeatureMenu {
    public static final String LOGICAL_TYPE_NAME = "isis.feat.ApplicationFeatureMenu";
    @Inject
    ApplicationFeatureRepository featureRepository;
    @Inject
    RepositoryService repository;
    @Inject
    FactoryService factory;

    @ObjectSupport
    public String iconName() {
        return "applicationFeature";
    }

    @Action(domainEvent=AllNamespacesDomainEvent.class, semantics=SemanticsOf.SAFE, restrictTo=RestrictTo.PROTOTYPING)
    @ActionLayout(cssClassFa="fa-list", sequence="100.40.1")
    public List<ApplicationNamespace> allNamespaces() {
        return this.asViewModels(this.featureRepository.allNamespaces(), ApplicationNamespace.class);
    }

    @Action(domainEvent=AllTypesDomainEvent.class, semantics=SemanticsOf.SAFE, restrictTo=RestrictTo.PROTOTYPING)
    @ActionLayout(cssClassFa="fa-list", sequence="100.40.2")
    public List<ApplicationType> allTypes() {
        return this.asViewModels(this.featureRepository.allTypes(), ApplicationType.class);
    }

    @Action(domainEvent=AllActionsDomainEvent.class, semantics=SemanticsOf.SAFE, restrictTo=RestrictTo.PROTOTYPING)
    @ActionLayout(cssClassFa="fa-list", sequence="100.40.3")
    public List<ApplicationTypeAction> allActions() {
        return this.asViewModels(this.featureRepository.allActions(), ApplicationTypeAction.class);
    }

    @Action(domainEvent=AllPropertiesDomainEvent.class, semantics=SemanticsOf.SAFE, restrictTo=RestrictTo.PROTOTYPING)
    @ActionLayout(cssClassFa="fa-list", sequence="100.40.4")
    public List<ApplicationTypeProperty> allProperties() {
        return this.asViewModels(this.featureRepository.allProperties(), ApplicationTypeProperty.class);
    }

    @Action(domainEvent=AllCollectionsDomainEvent.class, semantics=SemanticsOf.SAFE, restrictTo=RestrictTo.PROTOTYPING)
    @ActionLayout(cssClassFa="fa-list", sequence="100.40.5")
    public List<ApplicationTypeCollection> allCollections() {
        return this.asViewModels(this.featureRepository.allCollections(), ApplicationTypeCollection.class);
    }

    private <T extends ApplicationFeatureViewModel> List<T> asViewModels(Collection<ApplicationFeature> features, Class<T> viewmodelType) {
        return (List)features.stream().map(ApplicationFeature::getFeatureId).map(ApplicationFeatureViewModel.factory(this.featureRepository, this.factory, viewmodelType)).collect(_Lists.toUnmodifiable());
    }

    public static class AllCollectionsDomainEvent
    extends ActionDomainEvent {
    }

    public static class AllPropertiesDomainEvent
    extends ActionDomainEvent {
    }

    public static class AllActionsDomainEvent
    extends ActionDomainEvent {
    }

    public static class AllTypesDomainEvent
    extends ActionDomainEvent {
    }

    public static class AllNamespacesDomainEvent
    extends ActionDomainEvent {
    }

    public static abstract class ActionDomainEvent
    extends IsisModuleApplib.ActionDomainEvent<ApplicationFeatureMenu> {
    }

    public static abstract class CollectionDomainEvent<T>
    extends IsisModuleApplib.CollectionDomainEvent<ApplicationFeatureMenu, T> {
    }

    public static abstract class PropertyDomainEvent<T>
    extends IsisModuleApplib.PropertyDomainEvent<ApplicationFeatureMenu, T> {
    }
}

