/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.appfeat;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.function.Consumer;
import lombok.NonNull;
import org.apache.isis.applib.Identifier;
import org.apache.isis.applib.annotation.ObjectSupport;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.annotation.Value;
import org.apache.isis.applib.id.LogicalType;
import org.apache.isis.applib.services.appfeat.ApplicationFeatureSort;
import org.apache.isis.applib.util.Equality;
import org.apache.isis.applib.util.Hashing;
import org.apache.isis.applib.util.ObjectContracts;
import org.apache.isis.applib.util.TitleBuffer;
import org.apache.isis.applib.util.ToString;
import org.apache.isis.commons.collections.Can;
import org.apache.isis.commons.internal.assertions._Assert;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.commons.internal.exceptions._Exceptions;
import org.springframework.lang.Nullable;

@Value
public class ApplicationFeatureId
implements Comparable<ApplicationFeatureId>,
Serializable {
    private final Object $lock = new Object[0];
    private static final long serialVersionUID = 1L;
    public static final ApplicationFeatureId NAMESPACE_DEFAULT = ApplicationFeatureId.newNamespace("default");
    @NonNull
    final ApplicationFeatureSort sort;
    @Programmatic
    private String namespace;
    @Programmatic
    private String typeSimpleName;
    @Programmatic
    private String logicalMemberName;
    private transient Can<ApplicationFeatureId> pathIds;
    private static final Comparator<ApplicationFeatureId> bySort = Comparator.comparing(ApplicationFeatureId::getSort, Comparator.nullsFirst(Comparator.naturalOrder()));
    private static final Comparator<ApplicationFeatureId> byNamespace = Comparator.comparing(ApplicationFeatureId::getNamespace, Comparator.nullsFirst(Comparator.naturalOrder()));
    private static final Comparator<ApplicationFeatureId> byTypeSimpleName = Comparator.comparing(ApplicationFeatureId::getTypeSimpleName, Comparator.nullsFirst(Comparator.naturalOrder()));
    private static final Comparator<ApplicationFeatureId> byMemberName = Comparator.comparing(ApplicationFeatureId::getLogicalMemberName, Comparator.nullsFirst(Comparator.naturalOrder()));
    private static final Comparator<ApplicationFeatureId> comparator = Comparator.nullsFirst(bySort).thenComparing(byNamespace).thenComparing(byTypeSimpleName).thenComparing(byMemberName);
    private static final Equality<ApplicationFeatureId> equality = ObjectContracts.checkEquals(ApplicationFeatureId::getSort).thenCheckEquals(ApplicationFeatureId::getNamespace).thenCheckEquals(ApplicationFeatureId::getTypeSimpleName).thenCheckEquals(ApplicationFeatureId::getLogicalMemberName);
    private static final Hashing<ApplicationFeatureId> hashing = ObjectContracts.hashing(ApplicationFeatureId::getSort).thenHashing(ApplicationFeatureId::getNamespace).thenHashing(ApplicationFeatureId::getTypeSimpleName).thenHashing(ApplicationFeatureId::getLogicalMemberName);
    private static final ToString<ApplicationFeatureId> toString = ObjectContracts.toString("sort", ApplicationFeatureId::getSort).thenToString("namespace", ApplicationFeatureId::getNamespace).thenToStringOmitIfAbsent("typeSimpleName", ApplicationFeatureId::getTypeSimpleName).thenToStringOmitIfAbsent("memberName", ApplicationFeatureId::getLogicalMemberName);

    public static ApplicationFeatureId fromIdentifier(@NonNull Identifier identifier) {
        if (identifier == null) {
            throw new NullPointerException("identifier is marked non-null but is null");
        }
        String logicalTypeName = identifier.getLogicalTypeName();
        if (identifier.getType().isClass()) {
            return ApplicationFeatureId.newType(logicalTypeName);
        }
        return ApplicationFeatureId.newMember(logicalTypeName, identifier.getMemberLogicalName());
    }

    public static ApplicationFeatureId newFeature(@NonNull ApplicationFeatureSort featureSort, @NonNull String qualifiedLogicalName) {
        if (featureSort == null) {
            throw new NullPointerException("featureSort is marked non-null but is null");
        }
        if (qualifiedLogicalName == null) {
            throw new NullPointerException("qualifiedLogicalName is marked non-null but is null");
        }
        switch (featureSort) {
            case NAMESPACE: {
                return ApplicationFeatureId.newNamespace(qualifiedLogicalName);
            }
            case TYPE: {
                return ApplicationFeatureId.newType(qualifiedLogicalName);
            }
            case MEMBER: {
                return ApplicationFeatureId.newMember(qualifiedLogicalName);
            }
        }
        throw _Exceptions.illegalArgument((String)"Unknown feature sort '%s'", (Object[])new Object[]{featureSort});
    }

    public static ApplicationFeatureId newFeature(@NonNull String namespace, @Nullable String logicalTypeSimpleName, @Nullable String memberName) {
        if (namespace == null) {
            throw new NullPointerException("namespace is marked non-null but is null");
        }
        if (logicalTypeSimpleName == null) {
            return ApplicationFeatureId.newNamespace(namespace);
        }
        String logicalTypeName = namespace + "." + logicalTypeSimpleName;
        if (memberName == null) {
            return ApplicationFeatureId.newType(logicalTypeName);
        }
        return ApplicationFeatureId.newMember(logicalTypeName, memberName);
    }

    public static ApplicationFeatureId newNamespace(String namespace) {
        ApplicationFeatureId featureId = new ApplicationFeatureId(ApplicationFeatureSort.NAMESPACE);
        featureId.namespace = namespace;
        featureId.typeSimpleName = null;
        featureId.logicalMemberName = null;
        return featureId;
    }

    public static ApplicationFeatureId newNamespace(LogicalType logicalType) {
        return ApplicationFeatureId.newNamespace(logicalType.getNamespace());
    }

    public static ApplicationFeatureId newType(String logicalTypeName) {
        ApplicationFeatureId featureId = new ApplicationFeatureId(ApplicationFeatureSort.TYPE);
        ApplicationFeatureId.initType(featureId, logicalTypeName);
        return featureId;
    }

    public static ApplicationFeatureId newType(LogicalType logicalType) {
        return ApplicationFeatureId.newType(logicalType.getLogicalTypeName());
    }

    public static ApplicationFeatureId newMember(LogicalType logicalType, String memberLogicalName) {
        return ApplicationFeatureId.newMember(logicalType.getLogicalTypeName(), memberLogicalName);
    }

    public static ApplicationFeatureId newMember(String logicalTypeName, String memberLogicalName) {
        ApplicationFeatureId featureId = new ApplicationFeatureId(ApplicationFeatureSort.MEMBER);
        ApplicationFeatureId.initType(featureId, logicalTypeName);
        ApplicationFeatureId.initMember(featureId, memberLogicalName);
        return featureId;
    }

    public static ApplicationFeatureId newMember(String fullyQualifiedLogicalName) {
        ApplicationFeatureId featureId = new ApplicationFeatureId(ApplicationFeatureSort.MEMBER);
        int i = fullyQualifiedLogicalName.lastIndexOf("#");
        if (i == -1) {
            throw new IllegalArgumentException("Malformed, expected a '#': " + fullyQualifiedLogicalName);
        }
        String logicalTypeName = fullyQualifiedLogicalName.substring(0, i);
        String memberName = fullyQualifiedLogicalName.substring(i + 1);
        ApplicationFeatureId.initType(featureId, logicalTypeName);
        ApplicationFeatureId.initMember(featureId, memberName);
        return featureId;
    }

    private static void initType(ApplicationFeatureId featureId, String fullyQualifiedName) {
        int i = fullyQualifiedName.lastIndexOf(".");
        if (i != -1) {
            featureId.namespace = fullyQualifiedName.substring(0, i);
            featureId.typeSimpleName = fullyQualifiedName.substring(i + 1);
        } else {
            featureId.namespace = "";
            featureId.typeSimpleName = fullyQualifiedName;
        }
        if (_Strings.isEmpty((CharSequence)featureId.namespace)) {
            throw _Exceptions.illegalArgument((String)"fullyQualifiedName '%s' must include a non-empty namespace", (Object[])new Object[]{fullyQualifiedName});
        }
        featureId.logicalMemberName = null;
    }

    private static void initMember(ApplicationFeatureId featureId, @Nullable String memberLogicalName) {
        featureId.logicalMemberName = ApplicationFeatureId.stripOffParamsIfAny(memberLogicalName);
    }

    private static String stripOffParamsIfAny(@Nullable String name) {
        if (_Strings.isEmpty((CharSequence)name)) {
            return name;
        }
        int paramListStartIndex = name.indexOf(40);
        return paramListStartIndex > -1 ? name.substring(0, paramListStartIndex) : name;
    }

    private ApplicationFeatureId(ApplicationFeatureSort sort) {
        this.sort = sort;
    }

    @ObjectSupport
    public String title() {
        TitleBuffer buf = new TitleBuffer();
        buf.append(this.getFullyQualifiedName());
        return buf.toString();
    }

    public ApplicationFeatureId getParentTypeFeatureId() {
        _Assert.assertTrue((boolean)this.sort.isMember());
        String logicalTypeName = this.getNamespace() + "." + this.getTypeSimpleName();
        return ApplicationFeatureId.newType(logicalTypeName);
    }

    @Programmatic
    public String getFullyQualifiedName() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getNamespace());
        if (this.getTypeSimpleName() != null) {
            buf.append(".").append(this.getTypeSimpleName());
        }
        if (this.getLogicalMemberName() != null) {
            buf.append("#").append(this.getLogicalMemberName());
        }
        return buf.toString();
    }

    @Programmatic
    public String getLogicalTypeName() {
        if (this.getTypeSimpleName() == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        if (!_Strings.isNullOrEmpty((CharSequence)this.getNamespace())) {
            buf.append(this.getNamespace()).append(".");
        }
        buf.append(this.getTypeSimpleName());
        return buf.toString();
    }

    @Programmatic
    public ApplicationFeatureId getParentNamespaceFeatureId() {
        _Assert.assertFalse((boolean)this.sort.isMember());
        if (this.sort.isType()) {
            return ApplicationFeatureId.newNamespace(this.getNamespace());
        }
        String namespace = this.getNamespace();
        if (!namespace.contains(".")) {
            return null;
        }
        int cutOffPos = namespace.lastIndexOf(46);
        String parentPackageName = namespace.substring(0, cutOffPos);
        return ApplicationFeatureId.newNamespace(parentPackageName);
    }

    @Programmatic
    public String stringify() {
        return this.sort.name() + ":" + this.getFullyQualifiedName();
    }

    public static ApplicationFeatureId parse(String stringified) {
        return (ApplicationFeatureId)_Strings.splitThenApplyRequireNonEmpty((String)stringified, (String)":", (sort, fqn) -> ApplicationFeatureId.newFeature(ApplicationFeatureSort.valueOf(sort), fqn)).orElseThrow(() -> _Exceptions.illegalArgument((String)"cannot parse feature-id '%s'", (Object[])new Object[]{stringified}));
    }

    @Programmatic
    public String asEncodedString() {
        return _Strings.base64UrlEncode((String)this.stringify());
    }

    public static ApplicationFeatureId parseEncoded(String encodedString) {
        return ApplicationFeatureId.parse(_Strings.base64UrlDecode((String)encodedString));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Programmatic
    public Can<ApplicationFeatureId> getPathIds() {
        Object object = this.$lock;
        synchronized (object) {
            if (this.pathIds == null) {
                this.pathIds = ApplicationFeatureId.pathIds(this);
            }
            return this.pathIds;
        }
    }

    @Programmatic
    public Can<ApplicationFeatureId> getParentFeatureIds() {
        ApplicationFeatureId parent = this.getParentFeatureId();
        return parent != null ? this.getParentFeatureId().getPathIds() : Can.empty();
    }

    private ApplicationFeatureId getParentFeatureId() {
        return this.sort.isMember() ? this.getParentTypeFeatureId() : this.getParentNamespaceFeatureId();
    }

    private static Can<ApplicationFeatureId> pathIds(ApplicationFeatureId featureId) {
        ArrayList featureIds = _Lists.newArrayList();
        ApplicationFeatureId.visitSelfAndParents(featureId, featureIds::add);
        return Can.ofCollection((Collection)featureIds);
    }

    private static void visitSelfAndParents(ApplicationFeatureId featureId, Consumer<ApplicationFeatureId> onNext) {
        if (featureId != null) {
            onNext.accept(featureId);
            ApplicationFeatureId.visitSelfAndParents(featureId.getParentFeatureId(), onNext);
        }
    }

    public boolean contains(@NonNull ApplicationFeatureId otherFeatureId) {
        if (otherFeatureId == null) {
            throw new NullPointerException("otherFeatureId is marked non-null but is null");
        }
        return otherFeatureId.getPathIds().contains((Object)this);
    }

    @Override
    public int compareTo(ApplicationFeatureId other) {
        return comparator.compare(this, other);
    }

    public boolean equals(Object o) {
        return equality.equals(this, o);
    }

    public int hashCode() {
        return hashing.hashCode(this);
    }

    public String toString() {
        return toString.toString(this);
    }

    public ApplicationFeatureId withNamespace(@NonNull String namespace) {
        if (namespace == null) {
            throw new NullPointerException("namespace is marked non-null but is null");
        }
        return ApplicationFeatureId.newFeature(namespace, this.getTypeSimpleName(), this.getLogicalMemberName());
    }

    @NonNull
    public ApplicationFeatureSort getSort() {
        return this.sort;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getTypeSimpleName() {
        return this.typeSimpleName;
    }

    public String getLogicalMemberName() {
        return this.logicalMemberName;
    }
}

