/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.appfeat;

import java.util.Collections;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.SortedSet;
import javax.inject.Named;
import org.apache.isis.applib.annotation.SemanticsOf;
import org.apache.isis.applib.annotation.Value;
import org.apache.isis.applib.services.appfeat.ApplicationFeatureId;
import org.apache.isis.applib.services.appfeat.ApplicationMemberSort;

@Named(value="isis.sudo.ApplicationFeature")
@Value
public interface ApplicationFeature {
    public ApplicationFeatureId getFeatureId();

    default public String getFullyQualifiedName() {
        return this.getFeatureId().getFullyQualifiedName();
    }

    public Optional<ApplicationMemberSort> getMemberSort();

    default public SortedSet<ApplicationFeatureId> getMembersOfSort(ApplicationMemberSort memberSort) {
        switch (memberSort) {
            case PROPERTY: {
                return this.getProperties();
            }
            case COLLECTION: {
                return this.getCollections();
            }
            case ACTION: {
                return this.getActions();
            }
        }
        return Collections.emptySortedSet();
    }

    public Optional<Class<?>> getActionReturnType();

    public Optional<SemanticsOf> getActionSemantics();

    public boolean isPropertyOrCollectionDerived();

    public OptionalInt getPropertyTypicalLength();

    public OptionalInt getPropertyMaxLength();

    public SortedSet<ApplicationFeatureId> getContents();

    public SortedSet<ApplicationFeatureId> getProperties();

    public SortedSet<ApplicationFeatureId> getCollections();

    public SortedSet<ApplicationFeatureId> getActions();
}

