/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.query;

import org.apache.isis.applib.query.QueryRange;
import org.apache.isis.commons.internal.exceptions._Exceptions;

final class _QueryRangeDefault
implements QueryRange {
    private static final long serialVersionUID = 1L;
    private final long start;
    private final long limit;

    static _QueryRangeDefault of(long ... range) {
        return new _QueryRangeDefault(range);
    }

    _QueryRangeDefault(long[] range) {
        this.start = range.length > 0 ? range[0] : 0L;
        long l = this.limit = range.length > 1 ? range[1] : 0L;
        if (this.start < 0L) {
            throw _Exceptions.illegalArgument((String)"start cannot be a negative number, got %d", (Object[])new Object[]{this.start});
        }
        if (this.limit < 0L) {
            throw _Exceptions.illegalArgument((String)"limit cannot be a negative number, got %d", (Object[])new Object[]{this.limit});
        }
    }

    @Override
    public long getEnd() {
        if (!this.hasLimit()) {
            return Integer.MAX_VALUE;
        }
        long end = this.getStart() + this.getLimit();
        if (end < 0L || end > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return end;
    }

    @Override
    public boolean isUnconstrained() {
        return !this.hasOffset() && !this.hasLimit();
    }

    @Override
    public boolean hasOffset() {
        return this.getStart() != 0L;
    }

    @Override
    public boolean hasLimit() {
        return this.getLimit() != 0L;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof _QueryRangeDefault)) {
            return false;
        }
        _QueryRangeDefault other = (_QueryRangeDefault)o;
        if (this.getStart() != other.getStart()) {
            return false;
        }
        return this.getLimit() == other.getLimit();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $start = this.getStart();
        result = result * 59 + (int)($start >>> 32 ^ $start);
        long $limit = this.getLimit();
        result = result * 59 + (int)($limit >>> 32 ^ $limit);
        return result;
    }

    public String toString() {
        return "_QueryRangeDefault(start=" + this.getStart() + ", limit=" + this.getLimit() + ")";
    }

    @Override
    public long getStart() {
        return this.start;
    }

    @Override
    public long getLimit() {
        return this.limit;
    }
}

