/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.query;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;
import org.apache.isis.applib.query.NamedQuery;
import org.apache.isis.applib.query.QueryRange;
import org.apache.isis.applib.query._QueryAbstract;
import org.apache.isis.commons.internal.exceptions._Exceptions;
import org.springframework.lang.Nullable;

final class _NamedQueryDefault<T>
extends _QueryAbstract<T>
implements NamedQuery<T> {
    private static final long serialVersionUID = 1L;
    @NonNull
    private final String name;
    @NonNull
    private final Map<String, Object> parametersByName;

    protected _NamedQueryDefault(@NonNull Class<T> resultType, @NonNull String queryName, @NonNull QueryRange range, @Nullable Map<String, Object> parametersByName) {
        super(resultType, range);
        if (resultType == null) {
            throw new NullPointerException("resultType is marked non-null but is null");
        }
        if (queryName == null) {
            throw new NullPointerException("queryName is marked non-null but is null");
        }
        if (range == null) {
            throw new NullPointerException("range is marked non-null but is null");
        }
        this.name = queryName;
        this.parametersByName = parametersByName == null ? Collections.emptyMap() : Collections.unmodifiableMap(parametersByName);
    }

    @Override
    public String getDescription() {
        return this.getName() + " with " + this.getParametersByName();
    }

    @Override
    public _NamedQueryDefault<T> withRange(@NonNull QueryRange range) {
        if (range == null) {
            throw new NullPointerException("range is marked non-null but is null");
        }
        return new _NamedQueryDefault(this.getResultType(), this.getName(), range, this.getParametersByName());
    }

    @Override
    public NamedQuery<T> withParameter(@NonNull String parameterName, @Nullable Object parameterValue) {
        if (parameterName == null) {
            throw new NullPointerException("parameterName is marked non-null but is null");
        }
        if (parameterName.isEmpty()) {
            throw _Exceptions.illegalArgument((String)"require parameterName to be non empty, got '%s'", (Object[])new Object[]{parameterName});
        }
        HashMap<String, Object> params = this.parametersByName == null ? new HashMap<String, Object>() : new HashMap<String, Object>(this.getParametersByName());
        params.put(parameterName, parameterValue);
        return new _NamedQueryDefault(this.getResultType(), this.getName(), this.getRange(), params);
    }

    @Override
    @NonNull
    public String getName() {
        return this.name;
    }

    @Override
    @NonNull
    public Map<String, Object> getParametersByName() {
        return this.parametersByName;
    }
}

