/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.query;

import java.io.Serializable;
import org.apache.isis.applib.query._QueryRangeDefault;

public interface QueryRange
extends Serializable {
    public boolean isUnconstrained();

    public boolean hasOffset();

    public boolean hasLimit();

    public long getStart();

    public long getLimit();

    public long getEnd();

    default public int getStartAsInt() {
        return Math.toIntExact(this.getStart());
    }

    default public int getLimitAsInt() {
        long limit = this.getLimit();
        return limit <= Integer.MAX_VALUE ? Math.toIntExact(limit) : Integer.MAX_VALUE;
    }

    default public int getEndAsInt() {
        long end = this.getEnd();
        return end <= Integer.MAX_VALUE ? Math.toIntExact(end) : Integer.MAX_VALUE;
    }

    public static QueryRange unconstrained() {
        return QueryRange.of(0L, 0L);
    }

    public static QueryRange start(long start) {
        return QueryRange.of(start, 0L);
    }

    public static QueryRange limit(long limit) {
        return QueryRange.of(0L, limit);
    }

    public static QueryRange of(long ... range) {
        return new _QueryRangeDefault(range);
    }

    default public QueryRange withStart(long start) {
        return QueryRange.of(start, this.getLimit());
    }

    default public QueryRange withLimit(long limit) {
        return QueryRange.of(this.getStart(), limit);
    }
}

