/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.query;

import java.io.Serializable;
import lombok.NonNull;
import org.apache.isis.applib.query.NamedQuery;
import org.apache.isis.applib.query.QueryRange;
import org.apache.isis.applib.query._AllInstancesQueryDefault;
import org.apache.isis.applib.query._NamedQueryDefault;

public interface Query<T>
extends Serializable {
    public Class<T> getResultType();

    public String getDescription();

    public QueryRange getRange();

    public Query<T> withRange(@NonNull QueryRange var1);

    default public Query<T> withRange(long ... range) {
        return this.withRange(QueryRange.of(range));
    }

    default public Query<T> withStart(long start) {
        return this.withRange(start);
    }

    default public Query<T> withLimit(long limit) {
        return this.withRange(0L, limit);
    }

    public static <T> Query<T> allInstances(@NonNull Class<T> resultType) {
        if (resultType == null) {
            throw new NullPointerException("resultType is marked non-null but is null");
        }
        return new _AllInstancesQueryDefault<T>(resultType, QueryRange.unconstrained());
    }

    public static <T> NamedQuery<T> named(@NonNull Class<T> resultType, @NonNull String queryName) {
        if (resultType == null) {
            throw new NullPointerException("resultType is marked non-null but is null");
        }
        if (queryName == null) {
            throw new NullPointerException("queryName is marked non-null but is null");
        }
        return new _NamedQueryDefault<T>(resultType, queryName, QueryRange.unconstrained(), null);
    }
}

