/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.mixins.system;

import javax.inject.Inject;
import org.apache.isis.applib.annotation.Action;
import org.apache.isis.applib.annotation.ActionLayout;
import org.apache.isis.applib.annotation.MemberSupport;
import org.apache.isis.applib.annotation.SemanticsOf;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.services.bookmark.BookmarkService;
import org.apache.isis.applib.services.bookmark.HasTarget;
import org.apache.isis.applib.services.message.MessageService;
import org.apache.isis.applib.services.metamodel.BeanSort;
import org.apache.isis.applib.services.metamodel.MetaModelService;

@Action(semantics=SemanticsOf.SAFE)
@ActionLayout(named="Open", associateWith="target", sequence="1")
public class HasTarget_openTargetObject {
    private final HasTarget hasTarget;
    @Inject
    BookmarkService bookmarkService;
    @Inject
    MessageService messageService;
    @Inject
    MetaModelService metaModelService;

    @MemberSupport
    public Object act() {
        try {
            return this.bookmarkService != null ? this.bookmarkService.lookup(this.hasTarget.getTarget()).orElse(null) : null;
        }
        catch (RuntimeException ex) {
            if (ex.getClass().getName().contains("ObjectNotFoundException")) {
                this.messageService.warnUser("Object not found - has it since been deleted?");
                return null;
            }
            throw ex;
        }
    }

    @MemberSupport
    public boolean hideAct() {
        return this.hasTarget.getTarget() == null;
    }

    @MemberSupport
    public String disableAct() {
        Bookmark targetObject = this.hasTarget.getTarget();
        if (targetObject == null) {
            return null;
        }
        BeanSort sortOfObject = this.metaModelService.sortOf(this.hasTarget.getTarget(), MetaModelService.Mode.RELAXED);
        return !sortOfObject.isViewModel() && !sortOfObject.isEntity() ? "Can only open view models or entities" : null;
    }

    public HasTarget_openTargetObject(HasTarget hasTarget) {
        this.hasTarget = hasTarget;
    }
}

