/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.mixins.system;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.UUID;
import org.apache.isis.applib.annotation.DomainObject;
import org.apache.isis.applib.annotation.Editing;
import org.apache.isis.applib.annotation.Optionality;
import org.apache.isis.applib.annotation.Parameter;
import org.apache.isis.applib.annotation.Property;
import org.apache.isis.applib.annotation.PropertyLayout;
import org.apache.isis.applib.annotation.Publishing;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.mixins.security.HasUsername;
import org.apache.isis.applib.mixins.system.HasInteractionId;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.services.bookmark.HasTarget;

@DomainObject(editing=Editing.DISABLED, entityChangePublishing=Publishing.DISABLED)
public interface DomainChangeRecord
extends HasInteractionId,
HasUsername,
HasTarget {
    @Type
    public ChangeType getType();

    @Override
    @InteractionId
    public UUID getInteractionId();

    @Override
    @Username
    public String getUsername();

    @Timestamp
    public java.sql.Timestamp getTimestamp();

    @TargetLogicalTypeName
    default public String getTargetLogicalTypeName() {
        return this.getTarget().getLogicalTypeName();
    }

    @Override
    @Target
    public Bookmark getTarget();

    @LogicalMemberIdentifier
    public String getLogicalMemberIdentifier();

    default public boolean hideLogicalMemberIdentifier() {
        return this.getType() != ChangeType.COMMAND && this.getType() != ChangeType.EXECUTION;
    }

    @LogicalMemberIdentifier
    default public String getPropertyId() {
        return null;
    }

    default public boolean hidePropertyId() {
        return this.getType() != ChangeType.AUDIT_ENTRY;
    }

    @PreValue
    default public String getPreValue() {
        return null;
    }

    default public boolean hidePreValue() {
        return this.getType() != ChangeType.AUDIT_ENTRY;
    }

    @PostValue
    default public String getPostValue() {
        return null;
    }

    default public boolean hidePostValue() {
        return this.getType() != ChangeType.AUDIT_ENTRY;
    }

    @Property(editing=Editing.DISABLED, optionality=Optionality.OPTIONAL, maxLength=255)
    @PropertyLayout(hidden=Where.ALL_EXCEPT_STANDALONE_TABLES)
    @Parameter(optionality=Optionality.OPTIONAL, maxLength=255)
    @java.lang.annotation.Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface PostValue {
        public static final int MAX_LENGTH = 255;
        public static final boolean NULLABLE = true;
        public static final String ALLOWS_NULL = "true";
    }

    @Property(editing=Editing.DISABLED, optionality=Optionality.OPTIONAL, maxLength=255)
    @PropertyLayout(hidden=Where.ALL_EXCEPT_STANDALONE_TABLES)
    @Parameter(optionality=Optionality.OPTIONAL, maxLength=255)
    @java.lang.annotation.Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface PreValue {
        public static final int MAX_LENGTH = 255;
        public static final boolean NULLABLE = true;
        public static final String ALLOWS_NULL = "true";
    }

    @Property(editing=Editing.DISABLED, optionality=Optionality.OPTIONAL, maxLength=100)
    @Parameter(optionality=Optionality.OPTIONAL, maxLength=100)
    @java.lang.annotation.Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface PropertyId {
        public static final int MAX_LENGTH = 100;
        public static final boolean NULLABLE = true;
        public static final String ALLOWS_NULL = "true";
    }

    @Property(editing=Editing.DISABLED, optionality=Optionality.MANDATORY, maxLength=255)
    @Parameter(optionality=Optionality.MANDATORY, maxLength=255)
    @java.lang.annotation.Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface LogicalMemberIdentifier {
        public static final int MAX_LENGTH = 255;
        public static final boolean NULLABLE = false;
        public static final String ALLOWS_NULL = "false";
    }

    @Property(editing=Editing.DISABLED, maxLength=1500)
    @Parameter(maxLength=1500)
    @HasTarget.Target
    @java.lang.annotation.Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Target {
        public static final int MAX_LENGTH = 1500;
        public static final boolean NULLABLE = true;
        public static final String ALLOWS_NULL = "true";
    }

    @Property(editing=Editing.DISABLED, maxLength=255)
    @PropertyLayout(hidden=Where.ALL_TABLES)
    @Parameter(maxLength=255)
    @java.lang.annotation.Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface TargetLogicalTypeName {
        public static final int MAX_LENGTH = 255;
        public static final boolean NULLABLE = false;
        public static final String ALLOWS_NULL = "false";
    }

    @Property(editing=Editing.DISABLED)
    @java.lang.annotation.Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Timestamp {
        public static final boolean NULLABLE = false;
        public static final String ALLOWS_NULL = "false";
    }

    @Property(editing=Editing.DISABLED, maxLength=120)
    @Parameter(maxLength=120)
    @HasUsername.Username
    @java.lang.annotation.Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Username {
        public static final int MAX_LENGTH = 120;
        public static final boolean NULLABLE = false;
        public static final String ALLOWS_NULL = "false";
    }

    @Property(editing=Editing.DISABLED)
    @HasInteractionId.InteractionId
    @java.lang.annotation.Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface InteractionId {
        public static final boolean NULLABLE = false;
        public static final String ALLOWS_NULL = "false";
    }

    @Property(editing=Editing.DISABLED)
    @PropertyLayout(hidden=Where.ALL_EXCEPT_STANDALONE_TABLES)
    @java.lang.annotation.Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Type {
        public static final boolean NULLABLE = false;
        public static final String ALLOWS_NULL = "false";
    }

    public static enum ChangeType {
        COMMAND,
        AUDIT_ENTRY,
        EXECUTION;


        public String toString() {
            return this.name().replace("_", " ");
        }
    }
}

