/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.mixins.rest;

import java.util.Optional;
import javax.inject.Inject;
import org.apache.isis.applib.IsisModuleApplib;
import org.apache.isis.applib.annotation.Action;
import org.apache.isis.applib.annotation.ActionLayout;
import org.apache.isis.applib.annotation.MemberSupport;
import org.apache.isis.applib.annotation.Publishing;
import org.apache.isis.applib.annotation.RestrictTo;
import org.apache.isis.applib.annotation.SemanticsOf;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.services.bookmark.BookmarkService;
import org.apache.isis.applib.value.LocalResourcePath;

@Action(domainEvent=ActionDomainEvent.class, semantics=SemanticsOf.SAFE, commandPublishing=Publishing.DISABLED, executionPublishing=Publishing.DISABLED, restrictTo=RestrictTo.PROTOTYPING)
@ActionLayout(cssClassFa="fa-external-link-alt", describedAs="Opens up a view of this object as represented in the (Restful Objects) REST API", fieldSetId="metadata", position=ActionLayout.Position.PANEL_DROPDOWN, sequence="750.1")
public class Object_openRestApi {
    private final Object holder;
    @Inject
    BookmarkService bookmarkService;
    @Inject
    RestfulPathProvider restfulPathProvider;

    @MemberSupport
    public LocalResourcePath act() {
        Bookmark bookmark = this.bookmarkService.bookmarkForElseFail(this.holder);
        String logicalTypeName = bookmark.getLogicalTypeName();
        String objId = bookmark.getIdentifier();
        Optional<String> restfulPathIfAny = this.restfulPathProvider.getRestfulPath();
        String format = restfulPathIfAny.map(path -> String.format("%s/objects/%s/%s", path, logicalTypeName, objId)).orElseGet(() -> String.format("/objects/%s/%s", logicalTypeName, objId));
        return new LocalResourcePath(format);
    }

    public Object_openRestApi(Object holder) {
        this.holder = holder;
    }

    public static interface RestfulPathProvider {
        public Optional<String> getRestfulPath();
    }

    public static class ActionDomainEvent
    extends IsisModuleApplib.ActionDomainEvent<Object_openRestApi> {
    }
}

