/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.mixins.metamodel;

import javax.inject.Inject;
import org.apache.isis.applib.IsisModuleApplib;
import org.apache.isis.applib.annotation.Action;
import org.apache.isis.applib.annotation.MemberSupport;
import org.apache.isis.applib.annotation.Property;
import org.apache.isis.applib.annotation.PropertyLayout;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.services.bookmark.BookmarkService;
import org.apache.isis.applib.services.metamodel.BeanSort;
import org.apache.isis.applib.services.metamodel.MetaModelService;

@Property
@PropertyLayout(describedAs="The logical name of this domain class (as used in persistence, URLs etc).  Intended to be stable/unchanging across time", hidden=Where.ALL_TABLES, fieldSetId="metadata", sequence="400.1")
public class Object_logicalTypeName {
    @Inject
    BookmarkService bookmarkService;
    @Inject
    MetaModelService metaModelService;
    private final Object holder;

    @Action(domainEvent=ActionDomainEvent.class)
    @MemberSupport
    public String prop() {
        Bookmark bookmark = this.bookmarkService.bookmarkForElseFail(this.holder);
        return bookmark.getLogicalTypeName();
    }

    @MemberSupport
    public boolean hideProp() {
        Bookmark bookmark = this.bookmarkService.bookmarkForElseFail(this.holder);
        BeanSort beanSort = this.metaModelService.sortOf(bookmark, MetaModelService.Mode.RELAXED);
        return !beanSort.isEntity() && !beanSort.isViewModel();
    }

    public Object_logicalTypeName(Object holder) {
        this.holder = holder;
    }

    public static class ActionDomainEvent
    extends IsisModuleApplib.ActionDomainEvent<Object_logicalTypeName> {
    }
}

