/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.mixins.metamodel;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.isis.applib.IsisModuleApplib;
import org.apache.isis.applib.annotation.Action;
import org.apache.isis.applib.annotation.ActionLayout;
import org.apache.isis.applib.annotation.MemberSupport;
import org.apache.isis.applib.annotation.ParameterLayout;
import org.apache.isis.applib.annotation.Publishing;
import org.apache.isis.applib.annotation.RestrictTo;
import org.apache.isis.applib.annotation.SemanticsOf;
import org.apache.isis.applib.id.LogicalType;
import org.apache.isis.applib.services.jaxb.JaxbService;
import org.apache.isis.applib.services.message.MessageService;
import org.apache.isis.applib.services.metamodel.Config;
import org.apache.isis.applib.services.metamodel.MetaModelService;
import org.apache.isis.applib.value.Clob;
import org.apache.isis.applib.value.NamedWithMimeType;
import org.apache.isis.schema.metamodel.v2.MetamodelDto;

@Action(domainEvent=ActionDomainEvent.class, semantics=SemanticsOf.SAFE, commandPublishing=Publishing.DISABLED, executionPublishing=Publishing.DISABLED, restrictTo=RestrictTo.PROTOTYPING)
@ActionLayout(cssClassFa="fa-download", describedAs="Downloads a representation of the framework's internal metamodel for this object's domain class", fieldSetId="metadata", position=ActionLayout.Position.PANEL_DROPDOWN, sequence="700.2")
public class Object_downloadMetamodelXml {
    private final Object holder;
    @Inject
    MetaModelService metaModelService;
    @Inject
    MessageService messageService;
    @Inject
    JaxbService jaxbService;

    @MemberSupport
    public Object act(@ParameterLayout(named="File name", describedAs="File name extension can be omitted.") String fileName) {
        Optional<LogicalType> logicalTypeIfAny = this.metaModelService.lookupLogicalTypeByClass(this.holder.getClass());
        if (!logicalTypeIfAny.isPresent()) {
            this.messageService.warnUser("Unknown class, unable to export");
            return null;
        }
        String namespace = logicalTypeIfAny.get().getNamespace();
        Config config = Config.builder().ignoreFallbackFacets(true).ignoreAbstractClasses(true).ignoreInterfaces(true).ignoreBuiltInValueTypes(true).build().withNamespacePrefix(namespace);
        MetamodelDto metamodelDto = this.metaModelService.exportMetaModel(config);
        String className = this.holder.getClass().getName();
        List domainClassDtos = metamodelDto.getDomainClassDto();
        domainClassDtos.removeIf(classDto -> !Objects.equals(classDto.getId(), className));
        String xmlString = this.jaxbService.toXml(metamodelDto);
        return Clob.of(fileName, NamedWithMimeType.CommonMimeType.XML, xmlString);
    }

    @MemberSupport
    public String default0Act() {
        return this.holder.getClass().getSimpleName();
    }

    public Object_downloadMetamodelXml(Object holder) {
        this.holder = holder;
    }

    public static class ActionDomainEvent
    extends IsisModuleApplib.ActionDomainEvent<Object_downloadMetamodelXml> {
    }
}

