/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.mixins.layout;

import javax.inject.Inject;
import org.apache.isis.applib.IsisModuleApplib;
import org.apache.isis.applib.annotation.Action;
import org.apache.isis.applib.annotation.ActionLayout;
import org.apache.isis.applib.annotation.MemberSupport;
import org.apache.isis.applib.annotation.ParameterLayout;
import org.apache.isis.applib.annotation.Publishing;
import org.apache.isis.applib.annotation.RestrictTo;
import org.apache.isis.applib.annotation.SemanticsOf;
import org.apache.isis.applib.services.layout.LayoutExportStyle;
import org.apache.isis.applib.services.layout.LayoutService;
import org.apache.isis.applib.value.Clob;
import org.apache.isis.applib.value.NamedWithMimeType;

@Action(domainEvent=ActionDomainEvent.class, semantics=SemanticsOf.SAFE, commandPublishing=Publishing.DISABLED, executionPublishing=Publishing.DISABLED, restrictTo=RestrictTo.PROTOTYPING)
@ActionLayout(cssClassFa="fa-download", describedAs="Downloads the Xxx.layout.xml layout file effective/inferred for this object", fieldSetId="metadata", position=ActionLayout.Position.PANEL_DROPDOWN, sequence="700.1")
public class Object_downloadLayoutXml {
    private final Object holder;
    @Inject
    LayoutService layoutService;

    @MemberSupport
    public Object act(@ParameterLayout(named="File name", describedAs="File name extension can be omitted.") String fileName, LayoutExportStyle style) {
        String xmlString = this.layoutService.toXml(this.holder.getClass(), style);
        return Clob.of(fileName, NamedWithMimeType.CommonMimeType.XML, xmlString);
    }

    @MemberSupport
    public String default0Act() {
        return this.holder.getClass().getSimpleName() + ".layout";
    }

    @MemberSupport
    public LayoutExportStyle default1Act() {
        return LayoutExportStyle.defaults();
    }

    public Object_downloadLayoutXml(Object holder) {
        this.holder = holder;
    }

    public static class ActionDomainEvent
    extends IsisModuleApplib.ActionDomainEvent<Object_downloadLayoutXml> {
    }
}

