/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.mixins.dto;

import java.util.Map;
import javax.inject.Inject;
import org.apache.isis.applib.IsisModuleApplib;
import org.apache.isis.applib.annotation.Action;
import org.apache.isis.applib.annotation.ActionLayout;
import org.apache.isis.applib.annotation.MemberSupport;
import org.apache.isis.applib.annotation.ParameterLayout;
import org.apache.isis.applib.annotation.RestrictTo;
import org.apache.isis.applib.annotation.SemanticsOf;
import org.apache.isis.applib.mixins.dto.Dto;
import org.apache.isis.applib.services.jaxb.IsisSchemas;
import org.apache.isis.applib.services.jaxb.JaxbService;
import org.apache.isis.applib.services.message.MessageService;
import org.apache.isis.applib.util.ZipWriter;
import org.apache.isis.applib.value.Blob;
import org.apache.isis.applib.value.Clob;
import org.apache.isis.applib.value.NamedWithMimeType;

@Action(domainEvent=ActionDomainEvent.class, semantics=SemanticsOf.SAFE, restrictTo=RestrictTo.PROTOTYPING)
@ActionLayout(cssClassFa="fa-download", sequence="500.2")
public class Dto_downloadXsd {
    private final Dto holder;
    @Inject
    MessageService messageService;
    @Inject
    JaxbService jaxbService;

    @MemberSupport
    public Object act(@ParameterLayout(named="File name", describedAs="File name extension can be omitted.") String fileName, IsisSchemas isisSchemas) {
        Map<String, String> schemaMap = this.jaxbService.toXsd(this.holder, isisSchemas);
        if (schemaMap.isEmpty()) {
            String msg = String.format("No schemas were generated for %s; programming error?", this.holder.getClass().getName());
            this.messageService.warnUser(msg);
            return null;
        }
        if (schemaMap.size() == 1) {
            String xmlString = schemaMap.values().iterator().next();
            return Clob.of(fileName, NamedWithMimeType.CommonMimeType.XSD, xmlString);
        }
        ZipWriter zipWriter = ZipWriter.newInstance();
        for (Map.Entry<String, String> entry : schemaMap.entrySet()) {
            String namespaceUri = entry.getKey();
            String schemaText = entry.getValue();
            zipWriter.nextEntry(Dto_downloadXsd.zipEntryNameFor(namespaceUri), outputStream -> outputStream.writeCharactersUtf8(schemaText));
        }
        return Blob.of(fileName, NamedWithMimeType.CommonMimeType.ZIP, zipWriter.toBytes());
    }

    @MemberSupport
    public String default0Act() {
        return this.holder.getClass().getName();
    }

    @MemberSupport
    public IsisSchemas default1Act() {
        return IsisSchemas.IGNORE;
    }

    private static String zipEntryNameFor(String namespaceUri) {
        return namespaceUri + ".xsd";
    }

    public Dto_downloadXsd(Dto holder) {
        this.holder = holder;
    }

    public static class ActionDomainEvent
    extends IsisModuleApplib.ActionDomainEvent<Dto_downloadXsd> {
    }
}

