/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.locale;

import java.io.Serializable;
import java.util.Locale;
import lombok.NonNull;
import org.apache.isis.applib.annotation.Value;

@Value
public final class UserLocale
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NonNull
    private final Locale languageLocale;
    @NonNull
    private final Locale numberFormatLocale;
    @NonNull
    private final Locale timeFormatLocale;

    public static UserLocale getDefault() {
        return UserLocale.valueOf(Locale.getDefault());
    }

    public static UserLocale valueOf(Locale mainLocale) {
        return UserLocale.builder().languageLocale(mainLocale).numberFormatLocale(mainLocale).timeFormatLocale(mainLocale).build();
    }

    public UserLocaleBuilder asBuilder() {
        return UserLocale.builder().languageLocale(this.languageLocale).numberFormatLocale(this.numberFormatLocale).timeFormatLocale(this.timeFormatLocale);
    }

    UserLocale(@NonNull Locale languageLocale, @NonNull Locale numberFormatLocale, @NonNull Locale timeFormatLocale) {
        if (languageLocale == null) {
            throw new NullPointerException("languageLocale is marked non-null but is null");
        }
        if (numberFormatLocale == null) {
            throw new NullPointerException("numberFormatLocale is marked non-null but is null");
        }
        if (timeFormatLocale == null) {
            throw new NullPointerException("timeFormatLocale is marked non-null but is null");
        }
        this.languageLocale = languageLocale;
        this.numberFormatLocale = numberFormatLocale;
        this.timeFormatLocale = timeFormatLocale;
    }

    public static UserLocaleBuilder builder() {
        return new UserLocaleBuilder();
    }

    @NonNull
    public Locale getLanguageLocale() {
        return this.languageLocale;
    }

    @NonNull
    public Locale getNumberFormatLocale() {
        return this.numberFormatLocale;
    }

    @NonNull
    public Locale getTimeFormatLocale() {
        return this.timeFormatLocale;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserLocale)) {
            return false;
        }
        UserLocale other = (UserLocale)o;
        Locale this$languageLocale = this.getLanguageLocale();
        Locale other$languageLocale = other.getLanguageLocale();
        if (this$languageLocale == null ? other$languageLocale != null : !((Object)this$languageLocale).equals(other$languageLocale)) {
            return false;
        }
        Locale this$numberFormatLocale = this.getNumberFormatLocale();
        Locale other$numberFormatLocale = other.getNumberFormatLocale();
        if (this$numberFormatLocale == null ? other$numberFormatLocale != null : !((Object)this$numberFormatLocale).equals(other$numberFormatLocale)) {
            return false;
        }
        Locale this$timeFormatLocale = this.getTimeFormatLocale();
        Locale other$timeFormatLocale = other.getTimeFormatLocale();
        return !(this$timeFormatLocale == null ? other$timeFormatLocale != null : !((Object)this$timeFormatLocale).equals(other$timeFormatLocale));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Locale $languageLocale = this.getLanguageLocale();
        result = result * 59 + ($languageLocale == null ? 43 : ((Object)$languageLocale).hashCode());
        Locale $numberFormatLocale = this.getNumberFormatLocale();
        result = result * 59 + ($numberFormatLocale == null ? 43 : ((Object)$numberFormatLocale).hashCode());
        Locale $timeFormatLocale = this.getTimeFormatLocale();
        result = result * 59 + ($timeFormatLocale == null ? 43 : ((Object)$timeFormatLocale).hashCode());
        return result;
    }

    public String toString() {
        return "UserLocale(languageLocale=" + this.getLanguageLocale() + ", numberFormatLocale=" + this.getNumberFormatLocale() + ", timeFormatLocale=" + this.getTimeFormatLocale() + ")";
    }

    public static class UserLocaleBuilder {
        private Locale languageLocale;
        private Locale numberFormatLocale;
        private Locale timeFormatLocale;

        UserLocaleBuilder() {
        }

        public UserLocaleBuilder languageLocale(@NonNull Locale languageLocale) {
            if (languageLocale == null) {
                throw new NullPointerException("languageLocale is marked non-null but is null");
            }
            this.languageLocale = languageLocale;
            return this;
        }

        public UserLocaleBuilder numberFormatLocale(@NonNull Locale numberFormatLocale) {
            if (numberFormatLocale == null) {
                throw new NullPointerException("numberFormatLocale is marked non-null but is null");
            }
            this.numberFormatLocale = numberFormatLocale;
            return this;
        }

        public UserLocaleBuilder timeFormatLocale(@NonNull Locale timeFormatLocale) {
            if (timeFormatLocale == null) {
                throw new NullPointerException("timeFormatLocale is marked non-null but is null");
            }
            this.timeFormatLocale = timeFormatLocale;
            return this;
        }

        public UserLocale build() {
            return new UserLocale(this.languageLocale, this.numberFormatLocale, this.timeFormatLocale);
        }

        public String toString() {
            return "UserLocale.UserLocaleBuilder(languageLocale=" + this.languageLocale + ", numberFormatLocale=" + this.numberFormatLocale + ", timeFormatLocale=" + this.timeFormatLocale + ")";
        }
    }
}

