/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.layout.menubars.bootstrap;

import java.util.List;
import java.util.function.Consumer;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.isis.applib.annotation.DomainServiceLayout;
import org.apache.isis.applib.layout.component.ServiceActionLayoutData;
import org.apache.isis.applib.layout.menubars.MenuBarsAbstract;
import org.apache.isis.applib.layout.menubars.bootstrap.BSMenu;
import org.apache.isis.applib.layout.menubars.bootstrap.BSMenuBar;
import org.apache.isis.applib.layout.menubars.bootstrap.BSMenuSection;
import org.apache.isis.commons.internal.exceptions._Exceptions;

@XmlRootElement(name="menuBars")
@XmlType(name="menuBars", propOrder={"primary", "secondary", "tertiary", "metadataError"})
public class BSMenuBars
extends MenuBarsAbstract {
    private static final long serialVersionUID = 1L;
    private BSMenuBar primary = new BSMenuBar();
    private BSMenuBar secondary = new BSMenuBar();
    private BSMenuBar tertiary = new BSMenuBar();
    private String metadataError;

    public BSMenuBar getPrimary() {
        return this.primary;
    }

    public void setPrimary(BSMenuBar primary) {
        this.primary = primary;
    }

    public BSMenuBar getSecondary() {
        return this.secondary;
    }

    public void setSecondary(BSMenuBar secondary) {
        this.secondary = secondary;
    }

    public BSMenuBar getTertiary() {
        return this.tertiary;
    }

    public void setTertiary(BSMenuBar tertiary) {
        this.tertiary = tertiary;
    }

    @Override
    public BSMenuBar menuBarFor(DomainServiceLayout.MenuBar menuBar) {
        switch (menuBar) {
            case PRIMARY: {
                return this.getPrimary();
            }
            case SECONDARY: {
                return this.getSecondary();
            }
            case TERTIARY: {
                return this.getTertiary();
            }
            case NOT_SPECIFIED: {
                break;
            }
            default: {
                throw _Exceptions.unmatchedCase((Object)((Object)menuBar));
            }
        }
        return null;
    }

    @Override
    public void visit(Consumer<ServiceActionLayoutData> visitor) {
        this.traverseMenuBar(this.getPrimary(), visitor);
        this.traverseMenuBar(this.getSecondary(), visitor);
        this.traverseMenuBar(this.getTertiary(), visitor);
    }

    private void traverseMenuBar(BSMenuBar menuBar, Consumer<ServiceActionLayoutData> visitor) {
        Visitor bsVisitor;
        Visitor visitor2 = bsVisitor = visitor instanceof Visitor ? (Visitor)visitor : null;
        if (bsVisitor != null) {
            bsVisitor.preVisit(menuBar);
            bsVisitor.visit(menuBar);
        }
        for (BSMenu menu : menuBar.getMenus()) {
            this.traverseMenu(menu, visitor);
        }
        if (bsVisitor != null) {
            bsVisitor.postVisit(menuBar);
        }
    }

    private void traverseMenu(BSMenu menu, Consumer<ServiceActionLayoutData> visitor) {
        Visitor bsVisitor;
        Visitor visitor2 = bsVisitor = visitor instanceof Visitor ? (Visitor)visitor : null;
        if (bsVisitor != null) {
            bsVisitor.preVisit(menu);
            bsVisitor.visit(menu);
        }
        List<BSMenuSection> sections = menu.getSections();
        for (BSMenuSection section : sections) {
            this.traverseSection(section, visitor);
        }
        if (bsVisitor != null) {
            bsVisitor.postVisit(menu);
        }
    }

    private void traverseSection(BSMenuSection section, Consumer<ServiceActionLayoutData> visitor) {
        Visitor bsVisitor;
        Visitor visitor2 = bsVisitor = visitor instanceof Visitor ? (Visitor)visitor : null;
        if (bsVisitor != null) {
            bsVisitor.preVisit(section);
            bsVisitor.visit(section);
        }
        List<ServiceActionLayoutData> actions = section.getServiceActions();
        for (ServiceActionLayoutData action : actions) {
            visitor.accept(action);
        }
        if (bsVisitor != null) {
            bsVisitor.postVisit(section);
        }
    }

    @XmlElement(required=false)
    public String getMetadataError() {
        return this.metadataError;
    }

    public void setMetadataError(String metadataError) {
        this.metadataError = metadataError;
    }

    public static class VisitorAdapter
    implements Visitor {
        @Override
        public void preVisit(BSMenuBar menuBar) {
        }

        @Override
        public void visit(BSMenuBar menuBar) {
        }

        @Override
        public void postVisit(BSMenuBar menuBar) {
        }

        @Override
        public void preVisit(BSMenu menu) {
        }

        @Override
        public void visit(BSMenu menu) {
        }

        @Override
        public void postVisit(BSMenu menu) {
        }

        @Override
        public void preVisit(BSMenuSection menuSection) {
        }

        @Override
        public void visit(BSMenuSection section) {
        }

        @Override
        public void postVisit(BSMenuSection menuSection) {
        }

        @Override
        public void accept(ServiceActionLayoutData serviceActionLayoutData) {
        }

        public static VisitorAdapter visitingMenuSections(final Consumer<BSMenuSection> onVisit) {
            return new VisitorAdapter(){

                @Override
                public void visit(BSMenuSection section) {
                    onVisit.accept(section);
                }
            };
        }

        public static VisitorAdapter visitingMenus(final Consumer<BSMenu> onVisit) {
            return new VisitorAdapter(){

                @Override
                public void visit(BSMenu menu) {
                    onVisit.accept(menu);
                }
            };
        }
    }

    public static interface Visitor
    extends Consumer<ServiceActionLayoutData> {
        public void preVisit(BSMenuBar var1);

        public void visit(BSMenuBar var1);

        public void postVisit(BSMenuBar var1);

        public void preVisit(BSMenu var1);

        public void visit(BSMenu var1);

        public void postVisit(BSMenu var1);

        public void preVisit(BSMenuSection var1);

        public void visit(BSMenuSection var1);

        public void postVisit(BSMenuSection var1);
    }
}

